/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;
import software.amazon.awssdk.services.elasticbeanstalk.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlatformVersionRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CreatePlatformVersionRequest> {
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformName").getter(CreatePlatformVersionRequest.getter(CreatePlatformVersionRequest::platformName)).setter(CreatePlatformVersionRequest.setter(Builder::platformName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(CreatePlatformVersionRequest.getter(CreatePlatformVersionRequest::platformVersion)).setter(CreatePlatformVersionRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<S3Location> PLATFORM_DEFINITION_BUNDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlatformDefinitionBundle").getter(CreatePlatformVersionRequest.getter(CreatePlatformVersionRequest::platformDefinitionBundle)).setter(CreatePlatformVersionRequest.setter(Builder::platformDefinitionBundle)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDefinitionBundle").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(CreatePlatformVersionRequest.getter(CreatePlatformVersionRequest::environmentName)).setter(CreatePlatformVersionRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<List<ConfigurationOptionSetting>> OPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionSettings").getter(CreatePlatformVersionRequest.getter(CreatePlatformVersionRequest::optionSettings)).setter(CreatePlatformVersionRequest.setter(Builder::optionSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationOptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreatePlatformVersionRequest.getter(CreatePlatformVersionRequest::tags)).setter(CreatePlatformVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, PLATFORM_DEFINITION_BUNDLE_FIELD, ENVIRONMENT_NAME_FIELD, OPTION_SETTINGS_FIELD, TAGS_FIELD));
    private final String platformName;
    private final String platformVersion;
    private final S3Location platformDefinitionBundle;
    private final String environmentName;
    private final List<ConfigurationOptionSetting> optionSettings;
    private final List<Tag> tags;

    private CreatePlatformVersionRequest(BuilderImpl builder) {
        super(builder);
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.platformDefinitionBundle = builder.platformDefinitionBundle;
        this.environmentName = builder.environmentName;
        this.optionSettings = builder.optionSettings;
        this.tags = builder.tags;
    }

    public final String platformName() {
        return this.platformName;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final S3Location platformDefinitionBundle() {
        return this.platformDefinitionBundle;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final boolean hasOptionSettings() {
        return this.optionSettings != null && !(this.optionSettings instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.platformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDefinitionBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionSettings() ? this.optionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionRequest)) {
            return false;
        }
        CreatePlatformVersionRequest other = (CreatePlatformVersionRequest)((Object)obj);
        return Objects.equals(this.platformName(), other.platformName()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.platformDefinitionBundle(), other.platformDefinitionBundle()) && Objects.equals(this.environmentName(), other.environmentName()) && this.hasOptionSettings() == other.hasOptionSettings() && Objects.equals(this.optionSettings(), other.optionSettings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePlatformVersionRequest").add("PlatformName", (Object)this.platformName()).add("PlatformVersion", (Object)this.platformVersion()).add("PlatformDefinitionBundle", (Object)this.platformDefinitionBundle()).add("EnvironmentName", (Object)this.environmentName()).add("OptionSettings", this.hasOptionSettings() ? this.optionSettings() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformName": {
                return Optional.ofNullable(clazz.cast(this.platformName()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "PlatformDefinitionBundle": {
                return Optional.ofNullable(clazz.cast(this.platformDefinitionBundle()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "OptionSettings": {
                return Optional.ofNullable(clazz.cast(this.optionSettings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlatformVersionRequest, T> g) {
        return obj -> g.apply((CreatePlatformVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String platformName;
        private String platformVersion;
        private S3Location platformDefinitionBundle;
        private String environmentName;
        private List<ConfigurationOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformVersionRequest model) {
            super(model);
            this.platformName(model.platformName);
            this.platformVersion(model.platformVersion);
            this.platformDefinitionBundle(model.platformDefinitionBundle);
            this.environmentName(model.environmentName);
            this.optionSettings(model.optionSettings);
            this.tags(model.tags);
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final S3Location.Builder getPlatformDefinitionBundle() {
            return this.platformDefinitionBundle != null ? this.platformDefinitionBundle.toBuilder() : null;
        }

        @Override
        public final Builder platformDefinitionBundle(S3Location platformDefinitionBundle) {
            this.platformDefinitionBundle = platformDefinitionBundle;
            return this;
        }

        public final void setPlatformDefinitionBundle(S3Location.BuilderImpl platformDefinitionBundle) {
            this.platformDefinitionBundle = platformDefinitionBundle != null ? platformDefinitionBundle.build() : null;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Collection<ConfigurationOptionSetting.Builder> getOptionSettings() {
            if (this.optionSettings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.optionSettings != null ? (Collection)this.optionSettings.stream().map(ConfigurationOptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder> ... optionSettings) {
            this.optionSettings(Stream.of(optionSettings).map(c -> (ConfigurationOptionSetting)((ConfigurationOptionSetting.Builder)ConfigurationOptionSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlatformVersionRequest build() {
            return new CreatePlatformVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlatformVersionRequest> {
        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder platformDefinitionBundle(S3Location var1);

        default public Builder platformDefinitionBundle(Consumer<S3Location.Builder> platformDefinitionBundle) {
            return this.platformDefinitionBundle((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(platformDefinitionBundle)).build());
        }

        public Builder environmentName(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);

        public Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

