/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.AvailableSolutionStackDetailsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.AvailableSolutionStackNamesListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAvailableSolutionStacksResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ListAvailableSolutionStacksResponse> {
    private static final SdkField<List<String>> SOLUTION_STACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SolutionStacks").getter(ListAvailableSolutionStacksResponse.getter(ListAvailableSolutionStacksResponse::solutionStacks)).setter(ListAvailableSolutionStacksResponse.setter(Builder::solutionStacks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStacks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SolutionStackDescription>> SOLUTION_STACK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SolutionStackDetails").getter(ListAvailableSolutionStacksResponse.getter(ListAvailableSolutionStacksResponse::solutionStackDetails)).setter(ListAvailableSolutionStacksResponse.setter(Builder::solutionStackDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SolutionStackDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_STACKS_FIELD, SOLUTION_STACK_DETAILS_FIELD));
    private final List<String> solutionStacks;
    private final List<SolutionStackDescription> solutionStackDetails;

    private ListAvailableSolutionStacksResponse(BuilderImpl builder) {
        super(builder);
        this.solutionStacks = builder.solutionStacks;
        this.solutionStackDetails = builder.solutionStackDetails;
    }

    public final boolean hasSolutionStacks() {
        return this.solutionStacks != null && !(this.solutionStacks instanceof SdkAutoConstructList);
    }

    public final List<String> solutionStacks() {
        return this.solutionStacks;
    }

    public final boolean hasSolutionStackDetails() {
        return this.solutionStackDetails != null && !(this.solutionStackDetails instanceof SdkAutoConstructList);
    }

    public final List<SolutionStackDescription> solutionStackDetails() {
        return this.solutionStackDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSolutionStacks() ? this.solutionStacks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSolutionStackDetails() ? this.solutionStackDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableSolutionStacksResponse)) {
            return false;
        }
        ListAvailableSolutionStacksResponse other = (ListAvailableSolutionStacksResponse)((Object)obj);
        return this.hasSolutionStacks() == other.hasSolutionStacks() && Objects.equals(this.solutionStacks(), other.solutionStacks()) && this.hasSolutionStackDetails() == other.hasSolutionStackDetails() && Objects.equals(this.solutionStackDetails(), other.solutionStackDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ListAvailableSolutionStacksResponse").add("SolutionStacks", this.hasSolutionStacks() ? this.solutionStacks() : null).add("SolutionStackDetails", this.hasSolutionStackDetails() ? this.solutionStackDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SolutionStacks": {
                return Optional.ofNullable(clazz.cast(this.solutionStacks()));
            }
            case "SolutionStackDetails": {
                return Optional.ofNullable(clazz.cast(this.solutionStackDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableSolutionStacksResponse, T> g) {
        return obj -> g.apply((ListAvailableSolutionStacksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<String> solutionStacks = DefaultSdkAutoConstructList.getInstance();
        private List<SolutionStackDescription> solutionStackDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableSolutionStacksResponse model) {
            super(model);
            this.solutionStacks(model.solutionStacks);
            this.solutionStackDetails(model.solutionStackDetails);
        }

        public final Collection<String> getSolutionStacks() {
            if (this.solutionStacks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.solutionStacks;
        }

        @Override
        public final Builder solutionStacks(Collection<String> solutionStacks) {
            this.solutionStacks = AvailableSolutionStackNamesListCopier.copy(solutionStacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStacks(String ... solutionStacks) {
            this.solutionStacks(Arrays.asList(solutionStacks));
            return this;
        }

        public final void setSolutionStacks(Collection<String> solutionStacks) {
            this.solutionStacks = AvailableSolutionStackNamesListCopier.copy(solutionStacks);
        }

        public final Collection<SolutionStackDescription.Builder> getSolutionStackDetails() {
            if (this.solutionStackDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.solutionStackDetails != null ? (Collection)this.solutionStackDetails.stream().map(SolutionStackDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder solutionStackDetails(Collection<SolutionStackDescription> solutionStackDetails) {
            this.solutionStackDetails = AvailableSolutionStackDetailsListCopier.copy(solutionStackDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStackDetails(SolutionStackDescription ... solutionStackDetails) {
            this.solutionStackDetails(Arrays.asList(solutionStackDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStackDetails(Consumer<SolutionStackDescription.Builder> ... solutionStackDetails) {
            this.solutionStackDetails(Stream.of(solutionStackDetails).map(c -> (SolutionStackDescription)((SolutionStackDescription.Builder)SolutionStackDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSolutionStackDetails(Collection<SolutionStackDescription.BuilderImpl> solutionStackDetails) {
            this.solutionStackDetails = AvailableSolutionStackDetailsListCopier.copyFromBuilder(solutionStackDetails);
        }

        @Override
        public ListAvailableSolutionStacksResponse build() {
            return new ListAvailableSolutionStacksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAvailableSolutionStacksResponse> {
        public Builder solutionStacks(Collection<String> var1);

        public Builder solutionStacks(String ... var1);

        public Builder solutionStackDetails(Collection<SolutionStackDescription> var1);

        public Builder solutionStackDetails(SolutionStackDescription ... var1);

        public Builder solutionStackDetails(Consumer<SolutionStackDescription.Builder> ... var1);
    }
}

