/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi;
import software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmiListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFramework;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFrameworksCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguagesCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedAddonListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedTierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlatformDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlatformDescription> {
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformArn").getter(PlatformDescription.getter(PlatformDescription::platformArn)).setter(PlatformDescription.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<String> PLATFORM_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformOwner").getter(PlatformDescription.getter(PlatformDescription::platformOwner)).setter(PlatformDescription.setter(Builder::platformOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformOwner").build()}).build();
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformName").getter(PlatformDescription.getter(PlatformDescription::platformName)).setter(PlatformDescription.setter(Builder::platformName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(PlatformDescription.getter(PlatformDescription::platformVersion)).setter(PlatformDescription.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolutionStackName").getter(PlatformDescription.getter(PlatformDescription::solutionStackName)).setter(PlatformDescription.setter(Builder::solutionStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()}).build();
    private static final SdkField<String> PLATFORM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformStatus").getter(PlatformDescription.getter(PlatformDescription::platformStatusAsString)).setter(PlatformDescription.setter(Builder::platformStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformStatus").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(PlatformDescription.getter(PlatformDescription::dateCreated)).setter(PlatformDescription.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateUpdated").getter(PlatformDescription.getter(PlatformDescription::dateUpdated)).setter(PlatformDescription.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()}).build();
    private static final SdkField<String> PLATFORM_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformCategory").getter(PlatformDescription.getter(PlatformDescription::platformCategory)).setter(PlatformDescription.setter(Builder::platformCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformCategory").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PlatformDescription.getter(PlatformDescription::description)).setter(PlatformDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> MAINTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Maintainer").getter(PlatformDescription.getter(PlatformDescription::maintainer)).setter(PlatformDescription.setter(Builder::maintainer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maintainer").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystemName").getter(PlatformDescription.getter(PlatformDescription::operatingSystemName)).setter(PlatformDescription.setter(Builder::operatingSystemName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemName").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystemVersion").getter(PlatformDescription.getter(PlatformDescription::operatingSystemVersion)).setter(PlatformDescription.setter(Builder::operatingSystemVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build()}).build();
    private static final SdkField<List<PlatformProgrammingLanguage>> PROGRAMMING_LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProgrammingLanguages").getter(PlatformDescription.getter(PlatformDescription::programmingLanguages)).setter(PlatformDescription.setter(Builder::programmingLanguages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgrammingLanguages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlatformProgrammingLanguage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlatformFramework>> FRAMEWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Frameworks").getter(PlatformDescription.getter(PlatformDescription::frameworks)).setter(PlatformDescription.setter(Builder::frameworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frameworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlatformFramework::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CustomAmi>> CUSTOM_AMI_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomAmiList").getter(PlatformDescription.getter(PlatformDescription::customAmiList)).setter(PlatformDescription.setter(Builder::customAmiList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAmiList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomAmi::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTierList").getter(PlatformDescription.getter(PlatformDescription::supportedTierList)).setter(PlatformDescription.setter(Builder::supportedTierList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ADDON_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedAddonList").getter(PlatformDescription.getter(PlatformDescription::supportedAddonList)).setter(PlatformDescription.setter(Builder::supportedAddonList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAddonList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_LIFECYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformLifecycleState").getter(PlatformDescription.getter(PlatformDescription::platformLifecycleState)).setter(PlatformDescription.setter(Builder::platformLifecycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformLifecycleState").build()}).build();
    private static final SdkField<String> PLATFORM_BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformBranchName").getter(PlatformDescription.getter(PlatformDescription::platformBranchName)).setter(PlatformDescription.setter(Builder::platformBranchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchName").build()}).build();
    private static final SdkField<String> PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformBranchLifecycleState").getter(PlatformDescription.getter(PlatformDescription::platformBranchLifecycleState)).setter(PlatformDescription.setter(Builder::platformBranchLifecycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchLifecycleState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ARN_FIELD, PLATFORM_OWNER_FIELD, PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_STATUS_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, PLATFORM_CATEGORY_FIELD, DESCRIPTION_FIELD, MAINTAINER_FIELD, OPERATING_SYSTEM_NAME_FIELD, OPERATING_SYSTEM_VERSION_FIELD, PROGRAMMING_LANGUAGES_FIELD, FRAMEWORKS_FIELD, CUSTOM_AMI_LIST_FIELD, SUPPORTED_TIER_LIST_FIELD, SUPPORTED_ADDON_LIST_FIELD, PLATFORM_LIFECYCLE_STATE_FIELD, PLATFORM_BRANCH_NAME_FIELD, PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String platformArn;
    private final String platformOwner;
    private final String platformName;
    private final String platformVersion;
    private final String solutionStackName;
    private final String platformStatus;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final String platformCategory;
    private final String description;
    private final String maintainer;
    private final String operatingSystemName;
    private final String operatingSystemVersion;
    private final List<PlatformProgrammingLanguage> programmingLanguages;
    private final List<PlatformFramework> frameworks;
    private final List<CustomAmi> customAmiList;
    private final List<String> supportedTierList;
    private final List<String> supportedAddonList;
    private final String platformLifecycleState;
    private final String platformBranchName;
    private final String platformBranchLifecycleState;

    private PlatformDescription(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.solutionStackName = builder.solutionStackName;
        this.platformStatus = builder.platformStatus;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.platformCategory = builder.platformCategory;
        this.description = builder.description;
        this.maintainer = builder.maintainer;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.programmingLanguages = builder.programmingLanguages;
        this.frameworks = builder.frameworks;
        this.customAmiList = builder.customAmiList;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
        this.platformLifecycleState = builder.platformLifecycleState;
        this.platformBranchName = builder.platformBranchName;
        this.platformBranchLifecycleState = builder.platformBranchLifecycleState;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String platformOwner() {
        return this.platformOwner;
    }

    public String platformName() {
        return this.platformName;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public PlatformStatus platformStatus() {
        return PlatformStatus.fromValue(this.platformStatus);
    }

    public String platformStatusAsString() {
        return this.platformStatus;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateUpdated() {
        return this.dateUpdated;
    }

    public String platformCategory() {
        return this.platformCategory;
    }

    public String description() {
        return this.description;
    }

    public String maintainer() {
        return this.maintainer;
    }

    public String operatingSystemName() {
        return this.operatingSystemName;
    }

    public String operatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public boolean hasProgrammingLanguages() {
        return this.programmingLanguages != null && !(this.programmingLanguages instanceof SdkAutoConstructList);
    }

    public List<PlatformProgrammingLanguage> programmingLanguages() {
        return this.programmingLanguages;
    }

    public boolean hasFrameworks() {
        return this.frameworks != null && !(this.frameworks instanceof SdkAutoConstructList);
    }

    public List<PlatformFramework> frameworks() {
        return this.frameworks;
    }

    public boolean hasCustomAmiList() {
        return this.customAmiList != null && !(this.customAmiList instanceof SdkAutoConstructList);
    }

    public List<CustomAmi> customAmiList() {
        return this.customAmiList;
    }

    public boolean hasSupportedTierList() {
        return this.supportedTierList != null && !(this.supportedTierList instanceof SdkAutoConstructList);
    }

    public List<String> supportedTierList() {
        return this.supportedTierList;
    }

    public boolean hasSupportedAddonList() {
        return this.supportedAddonList != null && !(this.supportedAddonList instanceof SdkAutoConstructList);
    }

    public List<String> supportedAddonList() {
        return this.supportedAddonList;
    }

    public String platformLifecycleState() {
        return this.platformLifecycleState;
    }

    public String platformBranchName() {
        return this.platformBranchName;
    }

    public String platformBranchLifecycleState() {
        return this.platformBranchLifecycleState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.programmingLanguages());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworks());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAmiList());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedTierList());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedAddonList());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformLifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformBranchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformBranchLifecycleState());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformDescription)) {
            return false;
        }
        PlatformDescription other = (PlatformDescription)obj;
        return Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.platformOwner(), other.platformOwner()) && Objects.equals(this.platformName(), other.platformName()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformStatusAsString(), other.platformStatusAsString()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.platformCategory(), other.platformCategory()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.maintainer(), other.maintainer()) && Objects.equals(this.operatingSystemName(), other.operatingSystemName()) && Objects.equals(this.operatingSystemVersion(), other.operatingSystemVersion()) && Objects.equals(this.programmingLanguages(), other.programmingLanguages()) && Objects.equals(this.frameworks(), other.frameworks()) && Objects.equals(this.customAmiList(), other.customAmiList()) && Objects.equals(this.supportedTierList(), other.supportedTierList()) && Objects.equals(this.supportedAddonList(), other.supportedAddonList()) && Objects.equals(this.platformLifecycleState(), other.platformLifecycleState()) && Objects.equals(this.platformBranchName(), other.platformBranchName()) && Objects.equals(this.platformBranchLifecycleState(), other.platformBranchLifecycleState());
    }

    public String toString() {
        return ToString.builder((String)"PlatformDescription").add("PlatformArn", (Object)this.platformArn()).add("PlatformOwner", (Object)this.platformOwner()).add("PlatformName", (Object)this.platformName()).add("PlatformVersion", (Object)this.platformVersion()).add("SolutionStackName", (Object)this.solutionStackName()).add("PlatformStatus", (Object)this.platformStatusAsString()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("PlatformCategory", (Object)this.platformCategory()).add("Description", (Object)this.description()).add("Maintainer", (Object)this.maintainer()).add("OperatingSystemName", (Object)this.operatingSystemName()).add("OperatingSystemVersion", (Object)this.operatingSystemVersion()).add("ProgrammingLanguages", this.programmingLanguages()).add("Frameworks", this.frameworks()).add("CustomAmiList", this.customAmiList()).add("SupportedTierList", this.supportedTierList()).add("SupportedAddonList", this.supportedAddonList()).add("PlatformLifecycleState", (Object)this.platformLifecycleState()).add("PlatformBranchName", (Object)this.platformBranchName()).add("PlatformBranchLifecycleState", (Object)this.platformBranchLifecycleState()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "PlatformOwner": {
                return Optional.ofNullable(clazz.cast(this.platformOwner()));
            }
            case "PlatformName": {
                return Optional.ofNullable(clazz.cast(this.platformName()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "PlatformStatus": {
                return Optional.ofNullable(clazz.cast(this.platformStatusAsString()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "PlatformCategory": {
                return Optional.ofNullable(clazz.cast(this.platformCategory()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Maintainer": {
                return Optional.ofNullable(clazz.cast(this.maintainer()));
            }
            case "OperatingSystemName": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemName()));
            }
            case "OperatingSystemVersion": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemVersion()));
            }
            case "ProgrammingLanguages": {
                return Optional.ofNullable(clazz.cast(this.programmingLanguages()));
            }
            case "Frameworks": {
                return Optional.ofNullable(clazz.cast(this.frameworks()));
            }
            case "CustomAmiList": {
                return Optional.ofNullable(clazz.cast(this.customAmiList()));
            }
            case "SupportedTierList": {
                return Optional.ofNullable(clazz.cast(this.supportedTierList()));
            }
            case "SupportedAddonList": {
                return Optional.ofNullable(clazz.cast(this.supportedAddonList()));
            }
            case "PlatformLifecycleState": {
                return Optional.ofNullable(clazz.cast(this.platformLifecycleState()));
            }
            case "PlatformBranchName": {
                return Optional.ofNullable(clazz.cast(this.platformBranchName()));
            }
            case "PlatformBranchLifecycleState": {
                return Optional.ofNullable(clazz.cast(this.platformBranchLifecycleState()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformDescription, T> g) {
        return obj -> g.apply((PlatformDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String platformArn;
        private String platformOwner;
        private String platformName;
        private String platformVersion;
        private String solutionStackName;
        private String platformStatus;
        private Instant dateCreated;
        private Instant dateUpdated;
        private String platformCategory;
        private String description;
        private String maintainer;
        private String operatingSystemName;
        private String operatingSystemVersion;
        private List<PlatformProgrammingLanguage> programmingLanguages = DefaultSdkAutoConstructList.getInstance();
        private List<PlatformFramework> frameworks = DefaultSdkAutoConstructList.getInstance();
        private List<CustomAmi> customAmiList = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedAddonList = DefaultSdkAutoConstructList.getInstance();
        private String platformLifecycleState;
        private String platformBranchName;
        private String platformBranchLifecycleState;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformDescription model) {
            this.platformArn(model.platformArn);
            this.platformOwner(model.platformOwner);
            this.platformName(model.platformName);
            this.platformVersion(model.platformVersion);
            this.solutionStackName(model.solutionStackName);
            this.platformStatus(model.platformStatus);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.platformCategory(model.platformCategory);
            this.description(model.description);
            this.maintainer(model.maintainer);
            this.operatingSystemName(model.operatingSystemName);
            this.operatingSystemVersion(model.operatingSystemVersion);
            this.programmingLanguages(model.programmingLanguages);
            this.frameworks(model.frameworks);
            this.customAmiList(model.customAmiList);
            this.supportedTierList(model.supportedTierList);
            this.supportedAddonList(model.supportedAddonList);
            this.platformLifecycleState(model.platformLifecycleState);
            this.platformBranchName(model.platformBranchName);
            this.platformBranchLifecycleState(model.platformBranchLifecycleState);
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getPlatformOwner() {
            return this.platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformStatus() {
            return this.platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus == null ? null : platformStatus.toString());
            return this;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final String getPlatformCategory() {
            return this.platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMaintainer() {
            return this.maintainer;
        }

        @Override
        public final Builder maintainer(String maintainer) {
            this.maintainer = maintainer;
            return this;
        }

        public final void setMaintainer(String maintainer) {
            this.maintainer = maintainer;
        }

        public final String getOperatingSystemName() {
            return this.operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        public final String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        public final Collection<PlatformProgrammingLanguage.Builder> getProgrammingLanguages() {
            return this.programmingLanguages != null ? (Collection)this.programmingLanguages.stream().map(PlatformProgrammingLanguage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder programmingLanguages(Collection<PlatformProgrammingLanguage> programmingLanguages) {
            this.programmingLanguages = PlatformProgrammingLanguagesCopier.copy(programmingLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programmingLanguages(PlatformProgrammingLanguage ... programmingLanguages) {
            this.programmingLanguages(Arrays.asList(programmingLanguages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programmingLanguages(Consumer<PlatformProgrammingLanguage.Builder> ... programmingLanguages) {
            this.programmingLanguages(Stream.of(programmingLanguages).map(c -> (PlatformProgrammingLanguage)((PlatformProgrammingLanguage.Builder)PlatformProgrammingLanguage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProgrammingLanguages(Collection<PlatformProgrammingLanguage.BuilderImpl> programmingLanguages) {
            this.programmingLanguages = PlatformProgrammingLanguagesCopier.copyFromBuilder(programmingLanguages);
        }

        public final Collection<PlatformFramework.Builder> getFrameworks() {
            return this.frameworks != null ? (Collection)this.frameworks.stream().map(PlatformFramework::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder frameworks(Collection<PlatformFramework> frameworks) {
            this.frameworks = PlatformFrameworksCopier.copy(frameworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworks(PlatformFramework ... frameworks) {
            this.frameworks(Arrays.asList(frameworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworks(Consumer<PlatformFramework.Builder> ... frameworks) {
            this.frameworks(Stream.of(frameworks).map(c -> (PlatformFramework)((PlatformFramework.Builder)PlatformFramework.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFrameworks(Collection<PlatformFramework.BuilderImpl> frameworks) {
            this.frameworks = PlatformFrameworksCopier.copyFromBuilder(frameworks);
        }

        public final Collection<CustomAmi.Builder> getCustomAmiList() {
            return this.customAmiList != null ? (Collection)this.customAmiList.stream().map(CustomAmi::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customAmiList(Collection<CustomAmi> customAmiList) {
            this.customAmiList = CustomAmiListCopier.copy(customAmiList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmiList(CustomAmi ... customAmiList) {
            this.customAmiList(Arrays.asList(customAmiList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmiList(Consumer<CustomAmi.Builder> ... customAmiList) {
            this.customAmiList(Stream.of(customAmiList).map(c -> (CustomAmi)((CustomAmi.Builder)CustomAmi.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomAmiList(Collection<CustomAmi.BuilderImpl> customAmiList) {
            this.customAmiList = CustomAmiListCopier.copyFromBuilder(customAmiList);
        }

        public final Collection<String> getSupportedTierList() {
            return this.supportedTierList;
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String ... supportedTierList) {
            this.supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        public final Collection<String> getSupportedAddonList() {
            return this.supportedAddonList;
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String ... supportedAddonList) {
            this.supportedAddonList(Arrays.asList(supportedAddonList));
            return this;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        public final String getPlatformLifecycleState() {
            return this.platformLifecycleState;
        }

        @Override
        public final Builder platformLifecycleState(String platformLifecycleState) {
            this.platformLifecycleState = platformLifecycleState;
            return this;
        }

        public final void setPlatformLifecycleState(String platformLifecycleState) {
            this.platformLifecycleState = platformLifecycleState;
        }

        public final String getPlatformBranchName() {
            return this.platformBranchName;
        }

        @Override
        public final Builder platformBranchName(String platformBranchName) {
            this.platformBranchName = platformBranchName;
            return this;
        }

        public final void setPlatformBranchName(String platformBranchName) {
            this.platformBranchName = platformBranchName;
        }

        public final String getPlatformBranchLifecycleState() {
            return this.platformBranchLifecycleState;
        }

        @Override
        public final Builder platformBranchLifecycleState(String platformBranchLifecycleState) {
            this.platformBranchLifecycleState = platformBranchLifecycleState;
            return this;
        }

        public final void setPlatformBranchLifecycleState(String platformBranchLifecycleState) {
            this.platformBranchLifecycleState = platformBranchLifecycleState;
        }

        public PlatformDescription build() {
            return new PlatformDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlatformDescription> {
        public Builder platformArn(String var1);

        public Builder platformOwner(String var1);

        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformStatus(String var1);

        public Builder platformStatus(PlatformStatus var1);

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder platformCategory(String var1);

        public Builder description(String var1);

        public Builder maintainer(String var1);

        public Builder operatingSystemName(String var1);

        public Builder operatingSystemVersion(String var1);

        public Builder programmingLanguages(Collection<PlatformProgrammingLanguage> var1);

        public Builder programmingLanguages(PlatformProgrammingLanguage ... var1);

        public Builder programmingLanguages(Consumer<PlatformProgrammingLanguage.Builder> ... var1);

        public Builder frameworks(Collection<PlatformFramework> var1);

        public Builder frameworks(PlatformFramework ... var1);

        public Builder frameworks(Consumer<PlatformFramework.Builder> ... var1);

        public Builder customAmiList(Collection<CustomAmi> var1);

        public Builder customAmiList(CustomAmi ... var1);

        public Builder customAmiList(Consumer<CustomAmi.Builder> ... var1);

        public Builder supportedTierList(Collection<String> var1);

        public Builder supportedTierList(String ... var1);

        public Builder supportedAddonList(Collection<String> var1);

        public Builder supportedAddonList(String ... var1);

        public Builder platformLifecycleState(String var1);

        public Builder platformBranchName(String var1);

        public Builder platformBranchLifecycleState(String var1);
    }
}

