/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup;
import software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroupListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Instance;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfigurationListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchTemplate;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchTemplateListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Queue;
import software.amazon.awssdk.services.elasticbeanstalk.model.QueueListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Trigger;
import software.amazon.awssdk.services.elasticbeanstalk.model.TriggerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentResourceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentResourceDescription> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(EnvironmentResourceDescription.getter(EnvironmentResourceDescription::environmentName)).setter(EnvironmentResourceDescription.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<List<AutoScalingGroup>> AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoScalingGroups").getter(EnvironmentResourceDescription.getter(EnvironmentResourceDescription::autoScalingGroups)).setter(EnvironmentResourceDescription.setter(Builder::autoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(EnvironmentResourceDescription.getter(EnvironmentResourceDescription::instances)).setter(EnvironmentResourceDescription.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchConfiguration>> LAUNCH_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchConfigurations").getter(EnvironmentResourceDescription.getter(EnvironmentResourceDescription::launchConfigurations)).setter(EnvironmentResourceDescription.setter(Builder::launchConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplate>> LAUNCH_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchTemplates").getter(EnvironmentResourceDescription.getter(EnvironmentResourceDescription::launchTemplates)).setter(EnvironmentResourceDescription.setter(Builder::launchTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancers").getter(EnvironmentResourceDescription.getter(EnvironmentResourceDescription::loadBalancers)).setter(EnvironmentResourceDescription.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Triggers").getter(EnvironmentResourceDescription.getter(EnvironmentResourceDescription::triggers)).setter(EnvironmentResourceDescription.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Queue>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queues").getter(EnvironmentResourceDescription.getter(EnvironmentResourceDescription::queues)).setter(EnvironmentResourceDescription.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Queue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD, AUTO_SCALING_GROUPS_FIELD, INSTANCES_FIELD, LAUNCH_CONFIGURATIONS_FIELD, LAUNCH_TEMPLATES_FIELD, LOAD_BALANCERS_FIELD, TRIGGERS_FIELD, QUEUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String environmentName;
    private final List<AutoScalingGroup> autoScalingGroups;
    private final List<Instance> instances;
    private final List<LaunchConfiguration> launchConfigurations;
    private final List<LaunchTemplate> launchTemplates;
    private final List<LoadBalancer> loadBalancers;
    private final List<Trigger> triggers;
    private final List<Queue> queues;

    private EnvironmentResourceDescription(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.instances = builder.instances;
        this.launchConfigurations = builder.launchConfigurations;
        this.launchTemplates = builder.launchTemplates;
        this.loadBalancers = builder.loadBalancers;
        this.triggers = builder.triggers;
        this.queues = builder.queues;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public boolean hasAutoScalingGroups() {
        return this.autoScalingGroups != null && !(this.autoScalingGroups instanceof SdkAutoConstructList);
    }

    public List<AutoScalingGroup> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public boolean hasLaunchConfigurations() {
        return this.launchConfigurations != null && !(this.launchConfigurations instanceof SdkAutoConstructList);
    }

    public List<LaunchConfiguration> launchConfigurations() {
        return this.launchConfigurations;
    }

    public boolean hasLaunchTemplates() {
        return this.launchTemplates != null && !(this.launchTemplates instanceof SdkAutoConstructList);
    }

    public List<LaunchTemplate> launchTemplates() {
        return this.launchTemplates;
    }

    public boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public List<Trigger> triggers() {
        return this.triggers;
    }

    public boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public List<Queue> queues() {
        return this.queues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroups() ? this.autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchConfigurations() ? this.launchConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchTemplates() ? this.launchTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancers() ? this.loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResourceDescription)) {
            return false;
        }
        EnvironmentResourceDescription other = (EnvironmentResourceDescription)obj;
        return Objects.equals(this.environmentName(), other.environmentName()) && this.hasAutoScalingGroups() == other.hasAutoScalingGroups() && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && this.hasLaunchConfigurations() == other.hasLaunchConfigurations() && Objects.equals(this.launchConfigurations(), other.launchConfigurations()) && this.hasLaunchTemplates() == other.hasLaunchTemplates() && Objects.equals(this.launchTemplates(), other.launchTemplates()) && this.hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(this.loadBalancers(), other.loadBalancers()) && this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers()) && this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentResourceDescription").add("EnvironmentName", (Object)this.environmentName()).add("AutoScalingGroups", this.hasAutoScalingGroups() ? this.autoScalingGroups() : null).add("Instances", this.hasInstances() ? this.instances() : null).add("LaunchConfigurations", this.hasLaunchConfigurations() ? this.launchConfigurations() : null).add("LaunchTemplates", this.hasLaunchTemplates() ? this.launchTemplates() : null).add("LoadBalancers", this.hasLoadBalancers() ? this.loadBalancers() : null).add("Triggers", this.hasTriggers() ? this.triggers() : null).add("Queues", this.hasQueues() ? this.queues() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "AutoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroups()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "LaunchConfigurations": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurations()));
            }
            case "LaunchTemplates": {
                return Optional.ofNullable(clazz.cast(this.launchTemplates()));
            }
            case "LoadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "Triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentResourceDescription, T> g) {
        return obj -> g.apply((EnvironmentResourceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentName;
        private List<AutoScalingGroup> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchConfiguration> launchConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplate> launchTemplates = DefaultSdkAutoConstructList.getInstance();
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();
        private List<Queue> queues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResourceDescription model) {
            this.environmentName(model.environmentName);
            this.autoScalingGroups(model.autoScalingGroups);
            this.instances(model.instances);
            this.launchConfigurations(model.launchConfigurations);
            this.launchTemplates(model.launchTemplates);
            this.loadBalancers(model.loadBalancers);
            this.triggers(model.triggers);
            this.queues(model.queues);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Collection<AutoScalingGroup.Builder> getAutoScalingGroups() {
            if (this.autoScalingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoScalingGroups != null ? (Collection)this.autoScalingGroups.stream().map(AutoScalingGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder> ... autoScalingGroups) {
            this.autoScalingGroups(Stream.of(autoScalingGroups).map(c -> (AutoScalingGroup)((AutoScalingGroup.Builder)AutoScalingGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup.BuilderImpl> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copyFromBuilder(autoScalingGroups);
        }

        public final Collection<Instance.Builder> getInstances() {
            if (this.instances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final Collection<LaunchConfiguration.Builder> getLaunchConfigurations() {
            if (this.launchConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.launchConfigurations != null ? (Collection)this.launchConfigurations.stream().map(LaunchConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationListCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration ... launchConfigurations) {
            this.launchConfigurations(Arrays.asList(launchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(Consumer<LaunchConfiguration.Builder> ... launchConfigurations) {
            this.launchConfigurations(Stream.of(launchConfigurations).map(c -> (LaunchConfiguration)((LaunchConfiguration.Builder)LaunchConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration.BuilderImpl> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationListCopier.copyFromBuilder(launchConfigurations);
        }

        public final Collection<LaunchTemplate.Builder> getLaunchTemplates() {
            if (this.launchTemplates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.launchTemplates != null ? (Collection)this.launchTemplates.stream().map(LaunchTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplates(Collection<LaunchTemplate> launchTemplates) {
            this.launchTemplates = LaunchTemplateListCopier.copy(launchTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplates(LaunchTemplate ... launchTemplates) {
            this.launchTemplates(Arrays.asList(launchTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplates(Consumer<LaunchTemplate.Builder> ... launchTemplates) {
            this.launchTemplates(Stream.of(launchTemplates).map(c -> (LaunchTemplate)((LaunchTemplate.Builder)LaunchTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplates(Collection<LaunchTemplate.BuilderImpl> launchTemplates) {
            this.launchTemplates = LaunchTemplateListCopier.copyFromBuilder(launchTemplates);
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            if (this.loadBalancers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancers != null ? (Collection)this.loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<Trigger.Builder> getTriggers() {
            if (this.triggers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.triggers != null ? (Collection)this.triggers.stream().map(Trigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (Trigger)((Trigger.Builder)Trigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        public final Collection<Queue.Builder> getQueues() {
            if (this.queues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queues != null ? (Collection)this.queues.stream().map(Queue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queues(Collection<Queue> queues) {
            this.queues = QueueListCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Queue ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Consumer<Queue.Builder> ... queues) {
            this.queues(Stream.of(queues).map(c -> (Queue)((Queue.Builder)Queue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueues(Collection<Queue.BuilderImpl> queues) {
            this.queues = QueueListCopier.copyFromBuilder(queues);
        }

        public EnvironmentResourceDescription build() {
            return new EnvironmentResourceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentResourceDescription> {
        public Builder environmentName(String var1);

        public Builder autoScalingGroups(Collection<AutoScalingGroup> var1);

        public Builder autoScalingGroups(AutoScalingGroup ... var1);

        public Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder> ... var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder launchConfigurations(Collection<LaunchConfiguration> var1);

        public Builder launchConfigurations(LaunchConfiguration ... var1);

        public Builder launchConfigurations(Consumer<LaunchConfiguration.Builder> ... var1);

        public Builder launchTemplates(Collection<LaunchTemplate> var1);

        public Builder launchTemplates(LaunchTemplate ... var1);

        public Builder launchTemplates(Consumer<LaunchTemplate.Builder> ... var1);

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder triggers(Collection<Trigger> var1);

        public Builder triggers(Trigger ... var1);

        public Builder triggers(Consumer<Trigger.Builder> ... var1);

        public Builder queues(Collection<Queue> var1);

        public Builder queues(Queue ... var1);

        public Builder queues(Consumer<Queue.Builder> ... var1);
    }
}

