/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationResourceLifecycleResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, UpdateApplicationResourceLifecycleResponse> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(UpdateApplicationResourceLifecycleResponse.getter(UpdateApplicationResourceLifecycleResponse::applicationName)).setter(UpdateApplicationResourceLifecycleResponse.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<ApplicationResourceLifecycleConfig> RESOURCE_LIFECYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceLifecycleConfig").getter(UpdateApplicationResourceLifecycleResponse.getter(UpdateApplicationResourceLifecycleResponse::resourceLifecycleConfig)).setter(UpdateApplicationResourceLifecycleResponse.setter(Builder::resourceLifecycleConfig)).constructor(ApplicationResourceLifecycleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLifecycleConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, RESOURCE_LIFECYCLE_CONFIG_FIELD));
    private final String applicationName;
    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private UpdateApplicationResourceLifecycleResponse(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return this.resourceLifecycleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLifecycleConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationResourceLifecycleResponse)) {
            return false;
        }
        UpdateApplicationResourceLifecycleResponse other = (UpdateApplicationResourceLifecycleResponse)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.resourceLifecycleConfig(), other.resourceLifecycleConfig());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApplicationResourceLifecycleResponse").add("ApplicationName", (Object)this.applicationName()).add("ResourceLifecycleConfig", (Object)this.resourceLifecycleConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "ResourceLifecycleConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationResourceLifecycleResponse, T> g) {
        return obj -> g.apply((UpdateApplicationResourceLifecycleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String applicationName;
        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationResourceLifecycleResponse model) {
            super(model);
            this.applicationName(model.applicationName);
            this.resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return this.resourceLifecycleConfig != null ? this.resourceLifecycleConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        @Override
        public UpdateApplicationResourceLifecycleResponse build() {
            return new UpdateApplicationResourceLifecycleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationResourceLifecycleResponse> {
        public Builder applicationName(String var1);

        public Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig var1);

        default public Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return this.resourceLifecycleConfig((ApplicationResourceLifecycleConfig)((ApplicationResourceLifecycleConfig.Builder)ApplicationResourceLifecycleConfig.builder().applyMutation(resourceLifecycleConfig)).build());
        }
    }
}

