/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedAddonListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedTierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlatformSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlatformSummary> {
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlatformSummary.getter(PlatformSummary::platformArn)).setter(PlatformSummary.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<String> PLATFORM_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlatformSummary.getter(PlatformSummary::platformOwner)).setter(PlatformSummary.setter(Builder::platformOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformOwner").build()}).build();
    private static final SdkField<String> PLATFORM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlatformSummary.getter(PlatformSummary::platformStatusAsString)).setter(PlatformSummary.setter(Builder::platformStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformStatus").build()}).build();
    private static final SdkField<String> PLATFORM_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlatformSummary.getter(PlatformSummary::platformCategory)).setter(PlatformSummary.setter(Builder::platformCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformCategory").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlatformSummary.getter(PlatformSummary::operatingSystemName)).setter(PlatformSummary.setter(Builder::operatingSystemName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemName").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlatformSummary.getter(PlatformSummary::operatingSystemVersion)).setter(PlatformSummary.setter(Builder::operatingSystemVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PlatformSummary.getter(PlatformSummary::supportedTierList)).setter(PlatformSummary.setter(Builder::supportedTierList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ADDON_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PlatformSummary.getter(PlatformSummary::supportedAddonList)).setter(PlatformSummary.setter(Builder::supportedAddonList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAddonList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ARN_FIELD, PLATFORM_OWNER_FIELD, PLATFORM_STATUS_FIELD, PLATFORM_CATEGORY_FIELD, OPERATING_SYSTEM_NAME_FIELD, OPERATING_SYSTEM_VERSION_FIELD, SUPPORTED_TIER_LIST_FIELD, SUPPORTED_ADDON_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String platformArn;
    private final String platformOwner;
    private final String platformStatus;
    private final String platformCategory;
    private final String operatingSystemName;
    private final String operatingSystemVersion;
    private final List<String> supportedTierList;
    private final List<String> supportedAddonList;

    private PlatformSummary(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformStatus = builder.platformStatus;
        this.platformCategory = builder.platformCategory;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String platformOwner() {
        return this.platformOwner;
    }

    public PlatformStatus platformStatus() {
        return PlatformStatus.fromValue(this.platformStatus);
    }

    public String platformStatusAsString() {
        return this.platformStatus;
    }

    public String platformCategory() {
        return this.platformCategory;
    }

    public String operatingSystemName() {
        return this.operatingSystemName;
    }

    public String operatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public List<String> supportedTierList() {
        return this.supportedTierList;
    }

    public List<String> supportedAddonList() {
        return this.supportedAddonList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedTierList());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedAddonList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformSummary)) {
            return false;
        }
        PlatformSummary other = (PlatformSummary)obj;
        return Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.platformOwner(), other.platformOwner()) && Objects.equals(this.platformStatusAsString(), other.platformStatusAsString()) && Objects.equals(this.platformCategory(), other.platformCategory()) && Objects.equals(this.operatingSystemName(), other.operatingSystemName()) && Objects.equals(this.operatingSystemVersion(), other.operatingSystemVersion()) && Objects.equals(this.supportedTierList(), other.supportedTierList()) && Objects.equals(this.supportedAddonList(), other.supportedAddonList());
    }

    public String toString() {
        return ToString.builder((String)"PlatformSummary").add("PlatformArn", (Object)this.platformArn()).add("PlatformOwner", (Object)this.platformOwner()).add("PlatformStatus", (Object)this.platformStatusAsString()).add("PlatformCategory", (Object)this.platformCategory()).add("OperatingSystemName", (Object)this.operatingSystemName()).add("OperatingSystemVersion", (Object)this.operatingSystemVersion()).add("SupportedTierList", this.supportedTierList()).add("SupportedAddonList", this.supportedAddonList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "PlatformOwner": {
                return Optional.ofNullable(clazz.cast(this.platformOwner()));
            }
            case "PlatformStatus": {
                return Optional.ofNullable(clazz.cast(this.platformStatusAsString()));
            }
            case "PlatformCategory": {
                return Optional.ofNullable(clazz.cast(this.platformCategory()));
            }
            case "OperatingSystemName": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemName()));
            }
            case "OperatingSystemVersion": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemVersion()));
            }
            case "SupportedTierList": {
                return Optional.ofNullable(clazz.cast(this.supportedTierList()));
            }
            case "SupportedAddonList": {
                return Optional.ofNullable(clazz.cast(this.supportedAddonList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformSummary, T> g) {
        return obj -> g.apply((PlatformSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String platformArn;
        private String platformOwner;
        private String platformStatus;
        private String platformCategory;
        private String operatingSystemName;
        private String operatingSystemVersion;
        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedAddonList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformSummary model) {
            this.platformArn(model.platformArn);
            this.platformOwner(model.platformOwner);
            this.platformStatus(model.platformStatus);
            this.platformCategory(model.platformCategory);
            this.operatingSystemName(model.operatingSystemName);
            this.operatingSystemVersion(model.operatingSystemVersion);
            this.supportedTierList(model.supportedTierList);
            this.supportedAddonList(model.supportedAddonList);
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getPlatformOwner() {
            return this.platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        public final String getPlatformStatusAsString() {
            return this.platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus == null ? null : platformStatus.toString());
            return this;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        public final String getPlatformCategory() {
            return this.platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        public final String getOperatingSystemName() {
            return this.operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        public final String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        public final Collection<String> getSupportedTierList() {
            return this.supportedTierList;
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String ... supportedTierList) {
            this.supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        public final Collection<String> getSupportedAddonList() {
            return this.supportedAddonList;
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String ... supportedAddonList) {
            this.supportedAddonList(Arrays.asList(supportedAddonList));
            return this;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        public PlatformSummary build() {
            return new PlatformSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlatformSummary> {
        public Builder platformArn(String var1);

        public Builder platformOwner(String var1);

        public Builder platformStatus(String var1);

        public Builder platformStatus(PlatformStatus var1);

        public Builder platformCategory(String var1);

        public Builder operatingSystemName(String var1);

        public Builder operatingSystemVersion(String var1);

        public Builder supportedTierList(Collection<String> var1);

        public Builder supportedTierList(String ... var1);

        public Builder supportedAddonList(Collection<String> var1);

        public Builder supportedAddonList(String ... var1);
    }
}

