/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationVersionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationVersionDescription> {
    private static final SdkField<String> APPLICATION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::applicationVersionArn)).setter(ApplicationVersionDescription.setter(Builder::applicationVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionArn").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::applicationName)).setter(ApplicationVersionDescription.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::description)).setter(ApplicationVersionDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::versionLabel)).setter(ApplicationVersionDescription.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final SdkField<SourceBuildInformation> SOURCE_BUILD_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::sourceBuildInformation)).setter(ApplicationVersionDescription.setter(Builder::sourceBuildInformation)).constructor(SourceBuildInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBuildInformation").build()}).build();
    private static final SdkField<String> BUILD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::buildArn)).setter(ApplicationVersionDescription.setter(Builder::buildArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildArn").build()}).build();
    private static final SdkField<S3Location> SOURCE_BUNDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::sourceBundle)).setter(ApplicationVersionDescription.setter(Builder::sourceBundle)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBundle").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::dateCreated)).setter(ApplicationVersionDescription.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::dateUpdated)).setter(ApplicationVersionDescription.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationVersionDescription.getter(ApplicationVersionDescription::statusAsString)).setter(ApplicationVersionDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_ARN_FIELD, APPLICATION_NAME_FIELD, DESCRIPTION_FIELD, VERSION_LABEL_FIELD, SOURCE_BUILD_INFORMATION_FIELD, BUILD_ARN_FIELD, SOURCE_BUNDLE_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationVersionArn;
    private final String applicationName;
    private final String description;
    private final String versionLabel;
    private final SourceBuildInformation sourceBuildInformation;
    private final String buildArn;
    private final S3Location sourceBundle;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final String status;

    private ApplicationVersionDescription(BuilderImpl builder) {
        this.applicationVersionArn = builder.applicationVersionArn;
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.versionLabel = builder.versionLabel;
        this.sourceBuildInformation = builder.sourceBuildInformation;
        this.buildArn = builder.buildArn;
        this.sourceBundle = builder.sourceBundle;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.status = builder.status;
    }

    public String applicationVersionArn() {
        return this.applicationVersionArn;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String description() {
        return this.description;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public SourceBuildInformation sourceBuildInformation() {
        return this.sourceBuildInformation;
    }

    public String buildArn() {
        return this.buildArn;
    }

    public S3Location sourceBundle() {
        return this.sourceBundle;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateUpdated() {
        return this.dateUpdated;
    }

    public ApplicationVersionStatus status() {
        return ApplicationVersionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBuildInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionDescription)) {
            return false;
        }
        ApplicationVersionDescription other = (ApplicationVersionDescription)obj;
        return Objects.equals(this.applicationVersionArn(), other.applicationVersionArn()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.sourceBuildInformation(), other.sourceBuildInformation()) && Objects.equals(this.buildArn(), other.buildArn()) && Objects.equals(this.sourceBundle(), other.sourceBundle()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationVersionDescription").add("ApplicationVersionArn", (Object)this.applicationVersionArn()).add("ApplicationName", (Object)this.applicationName()).add("Description", (Object)this.description()).add("VersionLabel", (Object)this.versionLabel()).add("SourceBuildInformation", (Object)this.sourceBuildInformation()).add("BuildArn", (Object)this.buildArn()).add("SourceBundle", (Object)this.sourceBundle()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationVersionArn": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionArn()));
            }
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
            case "SourceBuildInformation": {
                return Optional.ofNullable(clazz.cast(this.sourceBuildInformation()));
            }
            case "BuildArn": {
                return Optional.ofNullable(clazz.cast(this.buildArn()));
            }
            case "SourceBundle": {
                return Optional.ofNullable(clazz.cast(this.sourceBundle()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationVersionDescription, T> g) {
        return obj -> g.apply((ApplicationVersionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationVersionArn;
        private String applicationName;
        private String description;
        private String versionLabel;
        private SourceBuildInformation sourceBuildInformation;
        private String buildArn;
        private S3Location sourceBundle;
        private Instant dateCreated;
        private Instant dateUpdated;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionDescription model) {
            this.applicationVersionArn(model.applicationVersionArn);
            this.applicationName(model.applicationName);
            this.description(model.description);
            this.versionLabel(model.versionLabel);
            this.sourceBuildInformation(model.sourceBuildInformation);
            this.buildArn(model.buildArn);
            this.sourceBundle(model.sourceBundle);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.status(model.status);
        }

        public final String getApplicationVersionArn() {
            return this.applicationVersionArn;
        }

        @Override
        public final Builder applicationVersionArn(String applicationVersionArn) {
            this.applicationVersionArn = applicationVersionArn;
            return this;
        }

        public final void setApplicationVersionArn(String applicationVersionArn) {
            this.applicationVersionArn = applicationVersionArn;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final SourceBuildInformation.Builder getSourceBuildInformation() {
            return this.sourceBuildInformation != null ? this.sourceBuildInformation.toBuilder() : null;
        }

        @Override
        public final Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
            return this;
        }

        public final void setSourceBuildInformation(SourceBuildInformation.BuilderImpl sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation != null ? sourceBuildInformation.build() : null;
        }

        public final String getBuildArn() {
            return this.buildArn;
        }

        @Override
        public final Builder buildArn(String buildArn) {
            this.buildArn = buildArn;
            return this;
        }

        public final void setBuildArn(String buildArn) {
            this.buildArn = buildArn;
        }

        public final S3Location.Builder getSourceBundle() {
            return this.sourceBundle != null ? this.sourceBundle.toBuilder() : null;
        }

        @Override
        public final Builder sourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        public final void setSourceBundle(S3Location.BuilderImpl sourceBundle) {
            this.sourceBundle = sourceBundle != null ? sourceBundle.build() : null;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ApplicationVersionDescription build() {
            return new ApplicationVersionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationVersionDescription> {
        public Builder applicationVersionArn(String var1);

        public Builder applicationName(String var1);

        public Builder description(String var1);

        public Builder versionLabel(String var1);

        public Builder sourceBuildInformation(SourceBuildInformation var1);

        default public Builder sourceBuildInformation(Consumer<SourceBuildInformation.Builder> sourceBuildInformation) {
            return this.sourceBuildInformation((SourceBuildInformation)((SourceBuildInformation.Builder)SourceBuildInformation.builder().applyMutation(sourceBuildInformation)).build());
        }

        public Builder buildArn(String var1);

        public Builder sourceBundle(S3Location var1);

        default public Builder sourceBundle(Consumer<S3Location.Builder> sourceBundle) {
            return this.sourceBundle((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(sourceBundle)).build());
        }

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder status(String var1);

        public Builder status(ApplicationVersionStatus var1);
    }
}

