/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.Latency;
import software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationMetrics> {
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ApplicationMetrics.getter(ApplicationMetrics::duration)).setter(ApplicationMetrics.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> REQUEST_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ApplicationMetrics.getter(ApplicationMetrics::requestCount)).setter(ApplicationMetrics.setter(Builder::requestCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCount").build()}).build();
    private static final SdkField<StatusCodes> STATUS_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationMetrics.getter(ApplicationMetrics::statusCodes)).setter(ApplicationMetrics.setter(Builder::statusCodes)).constructor(StatusCodes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCodes").build()}).build();
    private static final SdkField<Latency> LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ApplicationMetrics.getter(ApplicationMetrics::latency)).setter(ApplicationMetrics.setter(Builder::latency)).constructor(Latency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, REQUEST_COUNT_FIELD, STATUS_CODES_FIELD, LATENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer duration;
    private final Integer requestCount;
    private final StatusCodes statusCodes;
    private final Latency latency;

    private ApplicationMetrics(BuilderImpl builder) {
        this.duration = builder.duration;
        this.requestCount = builder.requestCount;
        this.statusCodes = builder.statusCodes;
        this.latency = builder.latency;
    }

    public Integer duration() {
        return this.duration;
    }

    public Integer requestCount() {
        return this.requestCount;
    }

    public StatusCodes statusCodes() {
        return this.statusCodes;
    }

    public Latency latency() {
        return this.latency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.latency());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationMetrics)) {
            return false;
        }
        ApplicationMetrics other = (ApplicationMetrics)obj;
        return Objects.equals(this.duration(), other.duration()) && Objects.equals(this.requestCount(), other.requestCount()) && Objects.equals(this.statusCodes(), other.statusCodes()) && Objects.equals(this.latency(), other.latency());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationMetrics").add("Duration", (Object)this.duration()).add("RequestCount", (Object)this.requestCount()).add("StatusCodes", (Object)this.statusCodes()).add("Latency", (Object)this.latency()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "RequestCount": {
                return Optional.ofNullable(clazz.cast(this.requestCount()));
            }
            case "StatusCodes": {
                return Optional.ofNullable(clazz.cast(this.statusCodes()));
            }
            case "Latency": {
                return Optional.ofNullable(clazz.cast(this.latency()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationMetrics, T> g) {
        return obj -> g.apply((ApplicationMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer duration;
        private Integer requestCount;
        private StatusCodes statusCodes;
        private Latency latency;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationMetrics model) {
            this.duration(model.duration);
            this.requestCount(model.requestCount);
            this.statusCodes(model.statusCodes);
            this.latency(model.latency);
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getRequestCount() {
            return this.requestCount;
        }

        @Override
        public final Builder requestCount(Integer requestCount) {
            this.requestCount = requestCount;
            return this;
        }

        public final void setRequestCount(Integer requestCount) {
            this.requestCount = requestCount;
        }

        public final StatusCodes.Builder getStatusCodes() {
            return this.statusCodes != null ? this.statusCodes.toBuilder() : null;
        }

        @Override
        public final Builder statusCodes(StatusCodes statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }

        public final void setStatusCodes(StatusCodes.BuilderImpl statusCodes) {
            this.statusCodes = statusCodes != null ? statusCodes.build() : null;
        }

        public final Latency.Builder getLatency() {
            return this.latency != null ? this.latency.toBuilder() : null;
        }

        @Override
        public final Builder latency(Latency latency) {
            this.latency = latency;
            return this;
        }

        public final void setLatency(Latency.BuilderImpl latency) {
            this.latency = latency != null ? latency.build() : null;
        }

        public ApplicationMetrics build() {
            return new ApplicationMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationMetrics> {
        public Builder duration(Integer var1);

        public Builder requestCount(Integer var1);

        public Builder statusCodes(StatusCodes var1);

        default public Builder statusCodes(Consumer<StatusCodes.Builder> statusCodes) {
            return this.statusCodes((StatusCodes)((StatusCodes.Builder)StatusCodes.builder().applyMutation(statusCodes)).build());
        }

        public Builder latency(Latency var1);

        default public Builder latency(Consumer<Latency.Builder> latency) {
            return this.latency((Latency)((Latency.Builder)Latency.builder().applyMutation(latency)).build());
        }
    }
}

