/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest;

public class RestartAppServerRequestMarshaller
implements Marshaller<Request<RestartAppServerRequest>, RestartAppServerRequest> {
    public Request<RestartAppServerRequest> marshall(RestartAppServerRequest restartAppServerRequest) {
        if (restartAppServerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)restartAppServerRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RestartAppServer");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (restartAppServerRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)restartAppServerRequest.environmentId()));
        }
        if (restartAppServerRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)restartAppServerRequest.environmentName()));
        }
        return request;
    }
}

