/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFramework;

public class PlatformFrameworkUnmarshaller
implements Unmarshaller<PlatformFramework, StaxUnmarshallerContext> {
    private static final PlatformFrameworkUnmarshaller INSTANCE = new PlatformFrameworkUnmarshaller();

    public PlatformFramework unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PlatformFramework.Builder platformFramework = PlatformFramework.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    platformFramework.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Version", targetDepth)) continue;
                platformFramework.version(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PlatformFramework)platformFramework.build();
    }

    public static PlatformFrameworkUnmarshaller getInstance() {
        return INSTANCE;
    }
}

