/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SwapEnvironmentCNAMEsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, SwapEnvironmentCNAMEsRequest> {
    private final String sourceEnvironmentId;
    private final String sourceEnvironmentName;
    private final String destinationEnvironmentId;
    private final String destinationEnvironmentName;

    private SwapEnvironmentCNAMEsRequest(BuilderImpl builder) {
        super(builder);
        this.sourceEnvironmentId = builder.sourceEnvironmentId;
        this.sourceEnvironmentName = builder.sourceEnvironmentName;
        this.destinationEnvironmentId = builder.destinationEnvironmentId;
        this.destinationEnvironmentName = builder.destinationEnvironmentName;
    }

    public String sourceEnvironmentId() {
        return this.sourceEnvironmentId;
    }

    public String sourceEnvironmentName() {
        return this.sourceEnvironmentName;
    }

    public String destinationEnvironmentId() {
        return this.destinationEnvironmentId;
    }

    public String destinationEnvironmentName() {
        return this.destinationEnvironmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEnvironmentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwapEnvironmentCNAMEsRequest)) {
            return false;
        }
        SwapEnvironmentCNAMEsRequest other = (SwapEnvironmentCNAMEsRequest)((Object)obj);
        return Objects.equals(this.sourceEnvironmentId(), other.sourceEnvironmentId()) && Objects.equals(this.sourceEnvironmentName(), other.sourceEnvironmentName()) && Objects.equals(this.destinationEnvironmentId(), other.destinationEnvironmentId()) && Objects.equals(this.destinationEnvironmentName(), other.destinationEnvironmentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceEnvironmentId() != null) {
            sb.append("SourceEnvironmentId: ").append(this.sourceEnvironmentId()).append(",");
        }
        if (this.sourceEnvironmentName() != null) {
            sb.append("SourceEnvironmentName: ").append(this.sourceEnvironmentName()).append(",");
        }
        if (this.destinationEnvironmentId() != null) {
            sb.append("DestinationEnvironmentId: ").append(this.destinationEnvironmentId()).append(",");
        }
        if (this.destinationEnvironmentName() != null) {
            sb.append("DestinationEnvironmentName: ").append(this.destinationEnvironmentName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceEnvironmentId": {
                return Optional.of(clazz.cast(this.sourceEnvironmentId()));
            }
            case "SourceEnvironmentName": {
                return Optional.of(clazz.cast(this.sourceEnvironmentName()));
            }
            case "DestinationEnvironmentId": {
                return Optional.of(clazz.cast(this.destinationEnvironmentId()));
            }
            case "DestinationEnvironmentName": {
                return Optional.of(clazz.cast(this.destinationEnvironmentName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String sourceEnvironmentId;
        private String sourceEnvironmentName;
        private String destinationEnvironmentId;
        private String destinationEnvironmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(SwapEnvironmentCNAMEsRequest model) {
            this.sourceEnvironmentId(model.sourceEnvironmentId);
            this.sourceEnvironmentName(model.sourceEnvironmentName);
            this.destinationEnvironmentId(model.destinationEnvironmentId);
            this.destinationEnvironmentName(model.destinationEnvironmentName);
        }

        public final String getSourceEnvironmentId() {
            return this.sourceEnvironmentId;
        }

        @Override
        public final Builder sourceEnvironmentId(String sourceEnvironmentId) {
            this.sourceEnvironmentId = sourceEnvironmentId;
            return this;
        }

        public final void setSourceEnvironmentId(String sourceEnvironmentId) {
            this.sourceEnvironmentId = sourceEnvironmentId;
        }

        public final String getSourceEnvironmentName() {
            return this.sourceEnvironmentName;
        }

        @Override
        public final Builder sourceEnvironmentName(String sourceEnvironmentName) {
            this.sourceEnvironmentName = sourceEnvironmentName;
            return this;
        }

        public final void setSourceEnvironmentName(String sourceEnvironmentName) {
            this.sourceEnvironmentName = sourceEnvironmentName;
        }

        public final String getDestinationEnvironmentId() {
            return this.destinationEnvironmentId;
        }

        @Override
        public final Builder destinationEnvironmentId(String destinationEnvironmentId) {
            this.destinationEnvironmentId = destinationEnvironmentId;
            return this;
        }

        public final void setDestinationEnvironmentId(String destinationEnvironmentId) {
            this.destinationEnvironmentId = destinationEnvironmentId;
        }

        public final String getDestinationEnvironmentName() {
            return this.destinationEnvironmentName;
        }

        @Override
        public final Builder destinationEnvironmentName(String destinationEnvironmentName) {
            this.destinationEnvironmentName = destinationEnvironmentName;
            return this;
        }

        public final void setDestinationEnvironmentName(String destinationEnvironmentName) {
            this.destinationEnvironmentName = destinationEnvironmentName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SwapEnvironmentCNAMEsRequest build() {
            return new SwapEnvironmentCNAMEsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, SwapEnvironmentCNAMEsRequest> {
        public Builder sourceEnvironmentId(String var1);

        public Builder sourceEnvironmentName(String var1);

        public Builder destinationEnvironmentId(String var1);

        public Builder destinationEnvironmentName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

