/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationVersionDescription
implements ToCopyableBuilder<Builder, ApplicationVersionDescription> {
    private final String applicationName;
    private final String description;
    private final String versionLabel;
    private final SourceBuildInformation sourceBuildInformation;
    private final String buildArn;
    private final S3Location sourceBundle;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final String status;

    private ApplicationVersionDescription(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.versionLabel = builder.versionLabel;
        this.sourceBuildInformation = builder.sourceBuildInformation;
        this.buildArn = builder.buildArn;
        this.sourceBundle = builder.sourceBundle;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.status = builder.status;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String description() {
        return this.description;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public SourceBuildInformation sourceBuildInformation() {
        return this.sourceBuildInformation;
    }

    public String buildArn() {
        return this.buildArn;
    }

    public S3Location sourceBundle() {
        return this.sourceBundle;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateUpdated() {
        return this.dateUpdated;
    }

    public ApplicationVersionStatus status() {
        return ApplicationVersionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBuildInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionDescription)) {
            return false;
        }
        ApplicationVersionDescription other = (ApplicationVersionDescription)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.sourceBuildInformation(), other.sourceBuildInformation()) && Objects.equals(this.buildArn(), other.buildArn()) && Objects.equals(this.sourceBundle(), other.sourceBundle()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.sourceBuildInformation() != null) {
            sb.append("SourceBuildInformation: ").append(this.sourceBuildInformation()).append(",");
        }
        if (this.buildArn() != null) {
            sb.append("BuildArn: ").append(this.buildArn()).append(",");
        }
        if (this.sourceBundle() != null) {
            sb.append("SourceBundle: ").append(this.sourceBundle()).append(",");
        }
        if (this.dateCreated() != null) {
            sb.append("DateCreated: ").append(this.dateCreated()).append(",");
        }
        if (this.dateUpdated() != null) {
            sb.append("DateUpdated: ").append(this.dateUpdated()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "SourceBuildInformation": {
                return Optional.of(clazz.cast(this.sourceBuildInformation()));
            }
            case "BuildArn": {
                return Optional.of(clazz.cast(this.buildArn()));
            }
            case "SourceBundle": {
                return Optional.of(clazz.cast(this.sourceBundle()));
            }
            case "DateCreated": {
                return Optional.of(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.of(clazz.cast(this.dateUpdated()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String description;
        private String versionLabel;
        private SourceBuildInformation sourceBuildInformation;
        private String buildArn;
        private S3Location sourceBundle;
        private Instant dateCreated;
        private Instant dateUpdated;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionDescription model) {
            this.applicationName(model.applicationName);
            this.description(model.description);
            this.versionLabel(model.versionLabel);
            this.sourceBuildInformation(model.sourceBuildInformation);
            this.buildArn(model.buildArn);
            this.sourceBundle(model.sourceBundle);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.status(model.status);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final SourceBuildInformation.Builder getSourceBuildInformation() {
            return this.sourceBuildInformation != null ? this.sourceBuildInformation.toBuilder() : null;
        }

        @Override
        public final Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
            return this;
        }

        public final void setSourceBuildInformation(SourceBuildInformation.BuilderImpl sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation != null ? sourceBuildInformation.build() : null;
        }

        public final String getBuildArn() {
            return this.buildArn;
        }

        @Override
        public final Builder buildArn(String buildArn) {
            this.buildArn = buildArn;
            return this;
        }

        public final void setBuildArn(String buildArn) {
            this.buildArn = buildArn;
        }

        public final S3Location.Builder getSourceBundle() {
            return this.sourceBundle != null ? this.sourceBundle.toBuilder() : null;
        }

        @Override
        public final Builder sourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        public final void setSourceBundle(S3Location.BuilderImpl sourceBundle) {
            this.sourceBundle = sourceBundle != null ? sourceBundle.build() : null;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationVersionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ApplicationVersionDescription build() {
            return new ApplicationVersionDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationVersionDescription> {
        public Builder applicationName(String var1);

        public Builder description(String var1);

        public Builder versionLabel(String var1);

        public Builder sourceBuildInformation(SourceBuildInformation var1);

        default public Builder sourceBuildInformation(Consumer<SourceBuildInformation.Builder> sourceBuildInformation) {
            return this.sourceBuildInformation((SourceBuildInformation)((SourceBuildInformation.Builder)SourceBuildInformation.builder().apply(sourceBuildInformation)).build());
        }

        public Builder buildArn(String var1);

        public Builder sourceBundle(S3Location var1);

        default public Builder sourceBundle(Consumer<S3Location.Builder> sourceBundle) {
            return this.sourceBundle((S3Location)((S3Location.Builder)S3Location.builder().apply(sourceBundle)).build());
        }

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder status(String var1);

        public Builder status(ApplicationVersionStatus var1);
    }
}

