/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;

public class RetrieveEnvironmentInfoRequestMarshaller
implements Marshaller<Request<RetrieveEnvironmentInfoRequest>, RetrieveEnvironmentInfoRequest> {
    public Request<RetrieveEnvironmentInfoRequest> marshall(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) {
        if (retrieveEnvironmentInfoRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)retrieveEnvironmentInfoRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RetrieveEnvironmentInfo");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (retrieveEnvironmentInfoRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)retrieveEnvironmentInfoRequest.environmentId()));
        }
        if (retrieveEnvironmentInfoRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)retrieveEnvironmentInfoRequest.environmentName()));
        }
        if (retrieveEnvironmentInfoRequest.infoTypeString() != null) {
            request.addParameter("InfoType", StringUtils.fromString((String)retrieveEnvironmentInfoRequest.infoTypeString()));
        }
        return request;
    }
}

