/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventDescription
implements ToCopyableBuilder<Builder, EventDescription> {
    private final Instant eventDate;
    private final String message;
    private final String applicationName;
    private final String versionLabel;
    private final String templateName;
    private final String environmentName;
    private final String platformArn;
    private final String requestId;
    private final String severity;

    private EventDescription(BuilderImpl builder) {
        this.eventDate = builder.eventDate;
        this.message = builder.message;
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
        this.platformArn = builder.platformArn;
        this.requestId = builder.requestId;
        this.severity = builder.severity;
    }

    public Instant eventDate() {
        return this.eventDate;
    }

    public String message() {
        return this.message;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String templateName() {
        return this.templateName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String requestId() {
        return this.requestId;
    }

    public EventSeverity severity() {
        return EventSeverity.fromValue(this.severity);
    }

    public String severityString() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDescription)) {
            return false;
        }
        EventDescription other = (EventDescription)obj;
        return Objects.equals(this.eventDate(), other.eventDate()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.severityString(), other.severityString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.eventDate() != null) {
            sb.append("EventDate: ").append(this.eventDate()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.requestId() != null) {
            sb.append("RequestId: ").append(this.requestId()).append(",");
        }
        if (this.severityString() != null) {
            sb.append("Severity: ").append(this.severityString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDate": {
                return Optional.of(clazz.cast(this.eventDate()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "TemplateName": {
                return Optional.of(clazz.cast(this.templateName()));
            }
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "PlatformArn": {
                return Optional.of(clazz.cast(this.platformArn()));
            }
            case "RequestId": {
                return Optional.of(clazz.cast(this.requestId()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severityString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant eventDate;
        private String message;
        private String applicationName;
        private String versionLabel;
        private String templateName;
        private String environmentName;
        private String platformArn;
        private String requestId;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDescription model) {
            this.eventDate(model.eventDate);
            this.message(model.message);
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.templateName(model.templateName);
            this.environmentName(model.environmentName);
            this.platformArn(model.platformArn);
            this.requestId(model.requestId);
            this.severity(model.severity);
        }

        public final Instant getEventDate() {
            return this.eventDate;
        }

        @Override
        public final Builder eventDate(Instant eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        public final void setEventDate(Instant eventDate) {
            this.eventDate = eventDate;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(EventSeverity severity) {
            this.severity(severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public EventDescription build() {
            return new EventDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventDescription> {
        public Builder eventDate(Instant var1);

        public Builder message(String var1);

        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder templateName(String var1);

        public Builder environmentName(String var1);

        public Builder platformArn(String var1);

        public Builder requestId(String var1);

        public Builder severity(String var1);

        public Builder severity(EventSeverity var1);
    }
}

