/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItemsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentManagedActionHistoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEnvironmentManagedActionHistoryResponse> {
    private final List<ManagedActionHistoryItem> managedActionHistoryItems;
    private final String nextToken;

    private DescribeEnvironmentManagedActionHistoryResponse(BuilderImpl builder) {
        this.managedActionHistoryItems = builder.managedActionHistoryItems;
        this.nextToken = builder.nextToken;
    }

    public List<ManagedActionHistoryItem> managedActionHistoryItems() {
        return this.managedActionHistoryItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.managedActionHistoryItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionHistoryResponse)) {
            return false;
        }
        DescribeEnvironmentManagedActionHistoryResponse other = (DescribeEnvironmentManagedActionHistoryResponse)((Object)obj);
        return Objects.equals(this.managedActionHistoryItems(), other.managedActionHistoryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.managedActionHistoryItems() != null) {
            sb.append("ManagedActionHistoryItems: ").append(this.managedActionHistoryItems()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedActionHistoryItems": {
                return Optional.of(clazz.cast(this.managedActionHistoryItems()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ManagedActionHistoryItem> managedActionHistoryItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionHistoryResponse model) {
            this.managedActionHistoryItems(model.managedActionHistoryItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ManagedActionHistoryItem.Builder> getManagedActionHistoryItems() {
            return this.managedActionHistoryItems != null ? (Collection)this.managedActionHistoryItems.stream().map(ManagedActionHistoryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder managedActionHistoryItems(Collection<ManagedActionHistoryItem> managedActionHistoryItems) {
            this.managedActionHistoryItems = ManagedActionHistoryItemsCopier.copy(managedActionHistoryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActionHistoryItems(ManagedActionHistoryItem ... managedActionHistoryItems) {
            this.managedActionHistoryItems(Arrays.asList(managedActionHistoryItems));
            return this;
        }

        public final void setManagedActionHistoryItems(Collection<ManagedActionHistoryItem.BuilderImpl> managedActionHistoryItems) {
            this.managedActionHistoryItems = ManagedActionHistoryItemsCopier.copyFromBuilder(managedActionHistoryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEnvironmentManagedActionHistoryResponse build() {
            return new DescribeEnvironmentManagedActionHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEnvironmentManagedActionHistoryResponse> {
        public Builder managedActionHistoryItems(Collection<ManagedActionHistoryItem> var1);

        public Builder managedActionHistoryItems(ManagedActionHistoryItem ... var1);

        public Builder nextToken(String var1);
    }
}

