/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeApplicationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeApplicationsResponse> {
    private final List<ApplicationDescription> applications;

    private DescribeApplicationsResponse(BuilderImpl builder) {
        this.applications = builder.applications;
    }

    public List<ApplicationDescription> applications() {
        return this.applications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsResponse)) {
            return false;
        }
        DescribeApplicationsResponse other = (DescribeApplicationsResponse)((Object)obj);
        return Objects.equals(this.applications(), other.applications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applications() != null) {
            sb.append("Applications: ").append(this.applications()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Applications": {
                return Optional.of(clazz.cast(this.applications()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ApplicationDescription> applications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsResponse model) {
            this.applications(model.applications);
        }

        public final Collection<ApplicationDescription.Builder> getApplications() {
            return this.applications != null ? (Collection)this.applications.stream().map(ApplicationDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applications(Collection<ApplicationDescription> applications) {
            this.applications = ApplicationDescriptionListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(ApplicationDescription ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<ApplicationDescription.BuilderImpl> applications) {
            this.applications = ApplicationDescriptionListCopier.copyFromBuilder(applications);
        }

        public DescribeApplicationsResponse build() {
            return new DescribeApplicationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeApplicationsResponse> {
        public Builder applications(Collection<ApplicationDescription> var1);

        public Builder applications(ApplicationDescription ... var1);
    }
}

