/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;

public class DescribeEnvironmentsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentsRequest>, DescribeEnvironmentsRequest> {
    public Request<DescribeEnvironmentsRequest> marshall(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        List<String> environmentNamesList;
        List<String> environmentIdsList;
        if (describeEnvironmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEnvironmentsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEnvironments");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeEnvironmentsRequest.applicationName()));
        }
        if (describeEnvironmentsRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)describeEnvironmentsRequest.versionLabel()));
        }
        if ((environmentIdsList = describeEnvironmentsRequest.environmentIds()) != null) {
            if (!environmentIdsList.isEmpty()) {
                int environmentIdsListIndex = 1;
                for (String environmentIdsListValue : environmentIdsList) {
                    if (environmentIdsListValue != null) {
                        request.addParameter("EnvironmentIds.member." + environmentIdsListIndex, StringUtils.fromString((String)environmentIdsListValue));
                    }
                    ++environmentIdsListIndex;
                }
            } else {
                request.addParameter("EnvironmentIds", "");
            }
        }
        if ((environmentNamesList = describeEnvironmentsRequest.environmentNames()) != null) {
            if (!environmentNamesList.isEmpty()) {
                int environmentNamesListIndex = 1;
                for (String environmentNamesListValue : environmentNamesList) {
                    if (environmentNamesListValue != null) {
                        request.addParameter("EnvironmentNames.member." + environmentNamesListIndex, StringUtils.fromString((String)environmentNamesListValue));
                    }
                    ++environmentNamesListIndex;
                }
            } else {
                request.addParameter("EnvironmentNames", "");
            }
        }
        if (describeEnvironmentsRequest.includeDeleted() != null) {
            request.addParameter("IncludeDeleted", StringUtils.fromBoolean((Boolean)describeEnvironmentsRequest.includeDeleted()));
        }
        if (describeEnvironmentsRequest.includedDeletedBackTo() != null) {
            request.addParameter("IncludedDeletedBackTo", StringUtils.fromInstant((Instant)describeEnvironmentsRequest.includedDeletedBackTo()));
        }
        return request;
    }
}

