/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;

public class DescribeApplicationsRequestMarshaller
implements Marshaller<Request<DescribeApplicationsRequest>, DescribeApplicationsRequest> {
    public Request<DescribeApplicationsRequest> marshall(DescribeApplicationsRequest describeApplicationsRequest) {
        if (describeApplicationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeApplicationsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeApplications");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> applicationNamesList = describeApplicationsRequest.applicationNames();
        if (applicationNamesList != null) {
            if (!applicationNamesList.isEmpty()) {
                int applicationNamesListIndex = 1;
                for (String applicationNamesListValue : applicationNamesList) {
                    if (applicationNamesListValue != null) {
                        request.addParameter("ApplicationNames.member." + applicationNamesListIndex, StringUtils.fromString((String)applicationNamesListValue));
                    }
                    ++applicationNamesListIndex;
                }
            } else {
                request.addParameter("ApplicationNames", "");
            }
        }
        return request;
    }
}

