/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceConfiguration;

public class CreateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<CreateConfigurationTemplateRequest>, CreateConfigurationTemplateRequest> {
    public Request<CreateConfigurationTemplateRequest> marshall(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        List<ConfigurationOptionSetting> optionSettingsList;
        SourceConfiguration sourceConfiguration;
        if (createConfigurationTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createConfigurationTemplateRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createConfigurationTemplateRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createConfigurationTemplateRequest.applicationName()));
        }
        if (createConfigurationTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)createConfigurationTemplateRequest.templateName()));
        }
        if (createConfigurationTemplateRequest.solutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString((String)createConfigurationTemplateRequest.solutionStackName()));
        }
        if (createConfigurationTemplateRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringUtils.fromString((String)createConfigurationTemplateRequest.platformArn()));
        }
        if ((sourceConfiguration = createConfigurationTemplateRequest.sourceConfiguration()) != null) {
            if (sourceConfiguration.applicationName() != null) {
                request.addParameter("SourceConfiguration.ApplicationName", StringUtils.fromString((String)sourceConfiguration.applicationName()));
            }
            if (sourceConfiguration.templateName() != null) {
                request.addParameter("SourceConfiguration.TemplateName", StringUtils.fromString((String)sourceConfiguration.templateName()));
            }
        }
        if (createConfigurationTemplateRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)createConfigurationTemplateRequest.environmentId()));
        }
        if (createConfigurationTemplateRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createConfigurationTemplateRequest.description()));
        }
        if ((optionSettingsList = createConfigurationTemplateRequest.optionSettings()) != null) {
            if (!optionSettingsList.isEmpty()) {
                int optionSettingsListIndex = 1;
                for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                    if (optionSettingsListValue.resourceName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.resourceName()));
                    }
                    if (optionSettingsListValue.namespace() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.namespace()));
                    }
                    if (optionSettingsListValue.optionName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.optionName()));
                    }
                    if (optionSettingsListValue.value() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.value()));
                    }
                    ++optionSettingsListIndex;
                }
            } else {
                request.addParameter("OptionSettings", "");
            }
        }
        return request;
    }
}

