/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessagesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidateConfigurationSettingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ValidateConfigurationSettingsResponse> {
    private final List<ValidationMessage> messages;

    private ValidateConfigurationSettingsResponse(BuilderImpl builder) {
        this.messages = builder.messages;
    }

    public List<ValidationMessage> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.messages() == null ? 0 : this.messages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateConfigurationSettingsResponse)) {
            return false;
        }
        ValidateConfigurationSettingsResponse other = (ValidateConfigurationSettingsResponse)((Object)obj);
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        return other.messages() == null || other.messages().equals(this.messages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.messages() != null) {
            sb.append("Messages: ").append(this.messages()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Messages": {
                return Optional.of(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ValidationMessage> messages;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateConfigurationSettingsResponse model) {
            this.messages(model.messages);
        }

        public final Collection<ValidationMessage.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(ValidationMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<ValidationMessage> messages) {
            this.messages = ValidationMessagesListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(ValidationMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<ValidationMessage.BuilderImpl> messages) {
            this.messages = ValidationMessagesListCopier.copyFromBuilder(messages);
        }

        public ValidateConfigurationSettingsResponse build() {
            return new ValidateConfigurationSettingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidateConfigurationSettingsResponse> {
        public Builder messages(Collection<ValidationMessage> var1);

        public Builder messages(ValidationMessage ... var1);
    }
}

