/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApplicationResourceLifecycleResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UpdateApplicationResourceLifecycleResponse> {
    private final String applicationName;
    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private UpdateApplicationResourceLifecycleResponse(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return this.resourceLifecycleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.resourceLifecycleConfig() == null ? 0 : this.resourceLifecycleConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationResourceLifecycleResponse)) {
            return false;
        }
        UpdateApplicationResourceLifecycleResponse other = (UpdateApplicationResourceLifecycleResponse)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.resourceLifecycleConfig() == null ^ this.resourceLifecycleConfig() == null) {
            return false;
        }
        return other.resourceLifecycleConfig() == null || other.resourceLifecycleConfig().equals(this.resourceLifecycleConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.resourceLifecycleConfig() != null) {
            sb.append("ResourceLifecycleConfig: ").append(this.resourceLifecycleConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "ResourceLifecycleConfig": {
                return Optional.of(clazz.cast(this.resourceLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationResourceLifecycleResponse model) {
            this.applicationName(model.applicationName);
            this.resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return this.resourceLifecycleConfig != null ? this.resourceLifecycleConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        public UpdateApplicationResourceLifecycleResponse build() {
            return new UpdateApplicationResourceLifecycleResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateApplicationResourceLifecycleResponse> {
        public Builder applicationName(String var1);

        public Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig var1);
    }
}

