/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionSpecification
implements ToCopyableBuilder<Builder, OptionSpecification> {
    private final String resourceName;
    private final String namespace;
    private final String optionName;

    private OptionSpecification(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String namespace() {
        return this.namespace;
    }

    public String optionName() {
        return this.optionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceName() == null ? 0 : this.resourceName().hashCode());
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.optionName() == null ? 0 : this.optionName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionSpecification)) {
            return false;
        }
        OptionSpecification other = (OptionSpecification)obj;
        if (other.resourceName() == null ^ this.resourceName() == null) {
            return false;
        }
        if (other.resourceName() != null && !other.resourceName().equals(this.resourceName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.optionName() == null ^ this.optionName() == null) {
            return false;
        }
        return other.optionName() == null || other.optionName().equals(this.optionName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.optionName() != null) {
            sb.append("OptionName: ").append(this.optionName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "OptionName": {
                return Optional.of(clazz.cast(this.optionName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private String namespace;
        private String optionName;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionSpecification model) {
            this.resourceName(model.resourceName);
            this.namespace(model.namespace);
            this.optionName(model.optionName);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public OptionSpecification build() {
            return new OptionSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionSpecification> {
        public Builder resourceName(String var1);

        public Builder namespace(String var1);

        public Builder optionName(String var1);
    }
}

