/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaxCountRule
implements ToCopyableBuilder<Builder, MaxCountRule> {
    private final Boolean enabled;
    private final Integer maxCount;
    private final Boolean deleteSourceFromS3;

    private MaxCountRule(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxCount = builder.maxCount;
        this.deleteSourceFromS3 = builder.deleteSourceFromS3;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer maxCount() {
        return this.maxCount;
    }

    public Boolean deleteSourceFromS3() {
        return this.deleteSourceFromS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.maxCount() == null ? 0 : this.maxCount().hashCode());
        hashCode = 31 * hashCode + (this.deleteSourceFromS3() == null ? 0 : this.deleteSourceFromS3().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaxCountRule)) {
            return false;
        }
        MaxCountRule other = (MaxCountRule)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.maxCount() == null ^ this.maxCount() == null) {
            return false;
        }
        if (other.maxCount() != null && !other.maxCount().equals(this.maxCount())) {
            return false;
        }
        if (other.deleteSourceFromS3() == null ^ this.deleteSourceFromS3() == null) {
            return false;
        }
        return other.deleteSourceFromS3() == null || other.deleteSourceFromS3().equals(this.deleteSourceFromS3());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.maxCount() != null) {
            sb.append("MaxCount: ").append(this.maxCount()).append(",");
        }
        if (this.deleteSourceFromS3() != null) {
            sb.append("DeleteSourceFromS3: ").append(this.deleteSourceFromS3()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "MaxCount": {
                return Optional.of(clazz.cast(this.maxCount()));
            }
            case "DeleteSourceFromS3": {
                return Optional.of(clazz.cast(this.deleteSourceFromS3()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer maxCount;
        private Boolean deleteSourceFromS3;

        private BuilderImpl() {
        }

        private BuilderImpl(MaxCountRule model) {
            this.enabled(model.enabled);
            this.maxCount(model.maxCount);
            this.deleteSourceFromS3(model.deleteSourceFromS3);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getMaxCount() {
            return this.maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        public final Boolean getDeleteSourceFromS3() {
            return this.deleteSourceFromS3;
        }

        @Override
        public final Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
            return this;
        }

        public final void setDeleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
        }

        public MaxCountRule build() {
            return new MaxCountRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaxCountRule> {
        public Builder enabled(Boolean var1);

        public Builder maxCount(Integer var1);

        public Builder deleteSourceFromS3(Boolean var1);
    }
}

