/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEventsRequest> {
    private final String applicationName;
    private final String versionLabel;
    private final String templateName;
    private final String environmentId;
    private final String environmentName;
    private final String platformArn;
    private final String requestId;
    private final String severity;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeEventsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.platformArn = builder.platformArn;
        this.requestId = builder.requestId;
        this.severity = builder.severity;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String templateName() {
        return this.templateName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String requestId() {
        return this.requestId;
    }

    public EventSeverity severity() {
        return EventSeverity.fromValue(this.severity);
    }

    public String severityString() {
        return this.severity;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.templateName() == null ? 0 : this.templateName().hashCode());
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.requestId() == null ? 0 : this.requestId().hashCode());
        hashCode = 31 * hashCode + (this.severityString() == null ? 0 : this.severityString().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsRequest)) {
            return false;
        }
        DescribeEventsRequest other = (DescribeEventsRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.templateName() == null ^ this.templateName() == null) {
            return false;
        }
        if (other.templateName() != null && !other.templateName().equals(this.templateName())) {
            return false;
        }
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.requestId() == null ^ this.requestId() == null) {
            return false;
        }
        if (other.requestId() != null && !other.requestId().equals(this.requestId())) {
            return false;
        }
        if (other.severityString() == null ^ this.severityString() == null) {
            return false;
        }
        if (other.severityString() != null && !other.severityString().equals(this.severityString())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.requestId() != null) {
            sb.append("RequestId: ").append(this.requestId()).append(",");
        }
        if (this.severityString() != null) {
            sb.append("Severity: ").append(this.severityString()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "TemplateName": {
                return Optional.of(clazz.cast(this.templateName()));
            }
            case "EnvironmentId": {
                return Optional.of(clazz.cast(this.environmentId()));
            }
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "PlatformArn": {
                return Optional.of(clazz.cast(this.platformArn()));
            }
            case "RequestId": {
                return Optional.of(clazz.cast(this.requestId()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severityString()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private String templateName;
        private String environmentId;
        private String environmentName;
        private String platformArn;
        private String requestId;
        private String severity;
        private Instant startTime;
        private Instant endTime;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsRequest model) {
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.templateName(model.templateName);
            this.environmentId(model.environmentId);
            this.environmentName(model.environmentName);
            this.platformArn(model.platformArn);
            this.requestId(model.requestId);
            this.severity(model.severity);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(EventSeverity severity) {
            this.severity(severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEventsRequest build() {
            return new DescribeEventsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventsRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder templateName(String var1);

        public Builder environmentId(String var1);

        public Builder environmentName(String var1);

        public Builder platformArn(String var1);

        public Builder requestId(String var1);

        public Builder severity(String var1);

        public Builder severity(EventSeverity var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);
    }
}

