/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics;
import software.amazon.awssdk.services.elasticbeanstalk.model.CausesCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealth;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentHealthResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEnvironmentHealthResponse> {
    private final String environmentName;
    private final String healthStatus;
    private final String status;
    private final String color;
    private final List<String> causes;
    private final ApplicationMetrics applicationMetrics;
    private final InstanceHealthSummary instancesHealth;
    private final Instant refreshedAt;

    private DescribeEnvironmentHealthResponse(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.healthStatus = builder.healthStatus;
        this.status = builder.status;
        this.color = builder.color;
        this.causes = builder.causes;
        this.applicationMetrics = builder.applicationMetrics;
        this.instancesHealth = builder.instancesHealth;
        this.refreshedAt = builder.refreshedAt;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String healthStatus() {
        return this.healthStatus;
    }

    public EnvironmentHealth status() {
        return EnvironmentHealth.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String color() {
        return this.color;
    }

    public List<String> causes() {
        return this.causes;
    }

    public ApplicationMetrics applicationMetrics() {
        return this.applicationMetrics;
    }

    public InstanceHealthSummary instancesHealth() {
        return this.instancesHealth;
    }

    public Instant refreshedAt() {
        return this.refreshedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.healthStatus() == null ? 0 : this.healthStatus().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.color() == null ? 0 : this.color().hashCode());
        hashCode = 31 * hashCode + (this.causes() == null ? 0 : this.causes().hashCode());
        hashCode = 31 * hashCode + (this.applicationMetrics() == null ? 0 : this.applicationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.instancesHealth() == null ? 0 : this.instancesHealth().hashCode());
        hashCode = 31 * hashCode + (this.refreshedAt() == null ? 0 : this.refreshedAt().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentHealthResponse)) {
            return false;
        }
        DescribeEnvironmentHealthResponse other = (DescribeEnvironmentHealthResponse)((Object)obj);
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.healthStatus() == null ^ this.healthStatus() == null) {
            return false;
        }
        if (other.healthStatus() != null && !other.healthStatus().equals(this.healthStatus())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.color() == null ^ this.color() == null) {
            return false;
        }
        if (other.color() != null && !other.color().equals(this.color())) {
            return false;
        }
        if (other.causes() == null ^ this.causes() == null) {
            return false;
        }
        if (other.causes() != null && !other.causes().equals(this.causes())) {
            return false;
        }
        if (other.applicationMetrics() == null ^ this.applicationMetrics() == null) {
            return false;
        }
        if (other.applicationMetrics() != null && !other.applicationMetrics().equals(this.applicationMetrics())) {
            return false;
        }
        if (other.instancesHealth() == null ^ this.instancesHealth() == null) {
            return false;
        }
        if (other.instancesHealth() != null && !other.instancesHealth().equals(this.instancesHealth())) {
            return false;
        }
        if (other.refreshedAt() == null ^ this.refreshedAt() == null) {
            return false;
        }
        return other.refreshedAt() == null || other.refreshedAt().equals(this.refreshedAt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.healthStatus() != null) {
            sb.append("HealthStatus: ").append(this.healthStatus()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.color() != null) {
            sb.append("Color: ").append(this.color()).append(",");
        }
        if (this.causes() != null) {
            sb.append("Causes: ").append(this.causes()).append(",");
        }
        if (this.applicationMetrics() != null) {
            sb.append("ApplicationMetrics: ").append(this.applicationMetrics()).append(",");
        }
        if (this.instancesHealth() != null) {
            sb.append("InstancesHealth: ").append(this.instancesHealth()).append(",");
        }
        if (this.refreshedAt() != null) {
            sb.append("RefreshedAt: ").append(this.refreshedAt()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "HealthStatus": {
                return Optional.of(clazz.cast(this.healthStatus()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Color": {
                return Optional.of(clazz.cast(this.color()));
            }
            case "Causes": {
                return Optional.of(clazz.cast(this.causes()));
            }
            case "ApplicationMetrics": {
                return Optional.of(clazz.cast(this.applicationMetrics()));
            }
            case "InstancesHealth": {
                return Optional.of(clazz.cast(this.instancesHealth()));
            }
            case "RefreshedAt": {
                return Optional.of(clazz.cast(this.refreshedAt()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentName;
        private String healthStatus;
        private String status;
        private String color;
        private List<String> causes;
        private ApplicationMetrics applicationMetrics;
        private InstanceHealthSummary instancesHealth;
        private Instant refreshedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentHealthResponse model) {
            this.environmentName(model.environmentName);
            this.healthStatus(model.healthStatus);
            this.status(model.status);
            this.color(model.color);
            this.causes(model.causes);
            this.applicationMetrics(model.applicationMetrics);
            this.instancesHealth(model.instancesHealth);
            this.refreshedAt(model.refreshedAt);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentHealth status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getColor() {
            return this.color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        public final Collection<String> getCauses() {
            return this.causes;
        }

        @Override
        public final Builder causes(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder causes(String ... causes) {
            this.causes(Arrays.asList(causes));
            return this;
        }

        public final void setCauses(Collection<String> causes) {
            this.causes = CausesCopier.copy(causes);
        }

        public final ApplicationMetrics.Builder getApplicationMetrics() {
            return this.applicationMetrics != null ? this.applicationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder applicationMetrics(ApplicationMetrics applicationMetrics) {
            this.applicationMetrics = applicationMetrics;
            return this;
        }

        public final void setApplicationMetrics(ApplicationMetrics.BuilderImpl applicationMetrics) {
            this.applicationMetrics = applicationMetrics != null ? applicationMetrics.build() : null;
        }

        public final InstanceHealthSummary.Builder getInstancesHealth() {
            return this.instancesHealth != null ? this.instancesHealth.toBuilder() : null;
        }

        @Override
        public final Builder instancesHealth(InstanceHealthSummary instancesHealth) {
            this.instancesHealth = instancesHealth;
            return this;
        }

        public final void setInstancesHealth(InstanceHealthSummary.BuilderImpl instancesHealth) {
            this.instancesHealth = instancesHealth != null ? instancesHealth.build() : null;
        }

        public final Instant getRefreshedAt() {
            return this.refreshedAt;
        }

        @Override
        public final Builder refreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
            return this;
        }

        public final void setRefreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
        }

        public DescribeEnvironmentHealthResponse build() {
            return new DescribeEnvironmentHealthResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEnvironmentHealthResponse> {
        public Builder environmentName(String var1);

        public Builder healthStatus(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentHealth var1);

        public Builder color(String var1);

        public Builder causes(Collection<String> var1);

        public Builder causes(String ... var1);

        public Builder applicationMetrics(ApplicationMetrics var1);

        public Builder instancesHealth(InstanceHealthSummary var1);

        public Builder refreshedAt(Instant var1);
    }
}

