/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateApplicationVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateApplicationVersionRequest> {
    private final String applicationName;
    private final String versionLabel;
    private final String description;
    private final SourceBuildInformation sourceBuildInformation;
    private final S3Location sourceBundle;
    private final BuildConfiguration buildConfiguration;
    private final Boolean autoCreateApplication;
    private final Boolean process;

    private CreateApplicationVersionRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.description = builder.description;
        this.sourceBuildInformation = builder.sourceBuildInformation;
        this.sourceBundle = builder.sourceBundle;
        this.buildConfiguration = builder.buildConfiguration;
        this.autoCreateApplication = builder.autoCreateApplication;
        this.process = builder.process;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String description() {
        return this.description;
    }

    public SourceBuildInformation sourceBuildInformation() {
        return this.sourceBuildInformation;
    }

    public S3Location sourceBundle() {
        return this.sourceBundle;
    }

    public BuildConfiguration buildConfiguration() {
        return this.buildConfiguration;
    }

    public Boolean autoCreateApplication() {
        return this.autoCreateApplication;
    }

    public Boolean process() {
        return this.process;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.sourceBuildInformation() == null ? 0 : this.sourceBuildInformation().hashCode());
        hashCode = 31 * hashCode + (this.sourceBundle() == null ? 0 : this.sourceBundle().hashCode());
        hashCode = 31 * hashCode + (this.buildConfiguration() == null ? 0 : this.buildConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.autoCreateApplication() == null ? 0 : this.autoCreateApplication().hashCode());
        hashCode = 31 * hashCode + (this.process() == null ? 0 : this.process().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationVersionRequest)) {
            return false;
        }
        CreateApplicationVersionRequest other = (CreateApplicationVersionRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.sourceBuildInformation() == null ^ this.sourceBuildInformation() == null) {
            return false;
        }
        if (other.sourceBuildInformation() != null && !other.sourceBuildInformation().equals(this.sourceBuildInformation())) {
            return false;
        }
        if (other.sourceBundle() == null ^ this.sourceBundle() == null) {
            return false;
        }
        if (other.sourceBundle() != null && !other.sourceBundle().equals(this.sourceBundle())) {
            return false;
        }
        if (other.buildConfiguration() == null ^ this.buildConfiguration() == null) {
            return false;
        }
        if (other.buildConfiguration() != null && !other.buildConfiguration().equals(this.buildConfiguration())) {
            return false;
        }
        if (other.autoCreateApplication() == null ^ this.autoCreateApplication() == null) {
            return false;
        }
        if (other.autoCreateApplication() != null && !other.autoCreateApplication().equals(this.autoCreateApplication())) {
            return false;
        }
        if (other.process() == null ^ this.process() == null) {
            return false;
        }
        return other.process() == null || other.process().equals(this.process());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.sourceBuildInformation() != null) {
            sb.append("SourceBuildInformation: ").append(this.sourceBuildInformation()).append(",");
        }
        if (this.sourceBundle() != null) {
            sb.append("SourceBundle: ").append(this.sourceBundle()).append(",");
        }
        if (this.buildConfiguration() != null) {
            sb.append("BuildConfiguration: ").append(this.buildConfiguration()).append(",");
        }
        if (this.autoCreateApplication() != null) {
            sb.append("AutoCreateApplication: ").append(this.autoCreateApplication()).append(",");
        }
        if (this.process() != null) {
            sb.append("Process: ").append(this.process()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "SourceBuildInformation": {
                return Optional.of(clazz.cast(this.sourceBuildInformation()));
            }
            case "SourceBundle": {
                return Optional.of(clazz.cast(this.sourceBundle()));
            }
            case "BuildConfiguration": {
                return Optional.of(clazz.cast(this.buildConfiguration()));
            }
            case "AutoCreateApplication": {
                return Optional.of(clazz.cast(this.autoCreateApplication()));
            }
            case "Process": {
                return Optional.of(clazz.cast(this.process()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private String description;
        private SourceBuildInformation sourceBuildInformation;
        private S3Location sourceBundle;
        private BuildConfiguration buildConfiguration;
        private Boolean autoCreateApplication;
        private Boolean process;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationVersionRequest model) {
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.description(model.description);
            this.sourceBuildInformation(model.sourceBuildInformation);
            this.sourceBundle(model.sourceBundle);
            this.buildConfiguration(model.buildConfiguration);
            this.autoCreateApplication(model.autoCreateApplication);
            this.process(model.process);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SourceBuildInformation.Builder getSourceBuildInformation() {
            return this.sourceBuildInformation != null ? this.sourceBuildInformation.toBuilder() : null;
        }

        @Override
        public final Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
            return this;
        }

        public final void setSourceBuildInformation(SourceBuildInformation.BuilderImpl sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation != null ? sourceBuildInformation.build() : null;
        }

        public final S3Location.Builder getSourceBundle() {
            return this.sourceBundle != null ? this.sourceBundle.toBuilder() : null;
        }

        @Override
        public final Builder sourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        public final void setSourceBundle(S3Location.BuilderImpl sourceBundle) {
            this.sourceBundle = sourceBundle != null ? sourceBundle.build() : null;
        }

        public final BuildConfiguration.Builder getBuildConfiguration() {
            return this.buildConfiguration != null ? this.buildConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder buildConfiguration(BuildConfiguration buildConfiguration) {
            this.buildConfiguration = buildConfiguration;
            return this;
        }

        public final void setBuildConfiguration(BuildConfiguration.BuilderImpl buildConfiguration) {
            this.buildConfiguration = buildConfiguration != null ? buildConfiguration.build() : null;
        }

        public final Boolean getAutoCreateApplication() {
            return this.autoCreateApplication;
        }

        @Override
        public final Builder autoCreateApplication(Boolean autoCreateApplication) {
            this.autoCreateApplication = autoCreateApplication;
            return this;
        }

        public final void setAutoCreateApplication(Boolean autoCreateApplication) {
            this.autoCreateApplication = autoCreateApplication;
        }

        public final Boolean getProcess() {
            return this.process;
        }

        @Override
        public final Builder process(Boolean process) {
            this.process = process;
            return this;
        }

        public final void setProcess(Boolean process) {
            this.process = process;
        }

        public CreateApplicationVersionRequest build() {
            return new CreateApplicationVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateApplicationVersionRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder description(String var1);

        public Builder sourceBuildInformation(SourceBuildInformation var1);

        public Builder sourceBundle(S3Location var1);

        public Builder buildConfiguration(BuildConfiguration var1);

        public Builder autoCreateApplication(Boolean var1);

        public Builder process(Boolean var1);
    }
}

