/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplyEnvironmentManagedActionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ApplyEnvironmentManagedActionResponse> {
    private final String actionId;
    private final String actionDescription;
    private final String actionType;
    private final String status;

    private ApplyEnvironmentManagedActionResponse(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionDescription = builder.actionDescription;
        this.actionType = builder.actionType;
        this.status = builder.status;
    }

    public String actionId() {
        return this.actionId;
    }

    public String actionDescription() {
        return this.actionDescription;
    }

    public ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public String actionTypeString() {
        return this.actionType;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionId() == null ? 0 : this.actionId().hashCode());
        hashCode = 31 * hashCode + (this.actionDescription() == null ? 0 : this.actionDescription().hashCode());
        hashCode = 31 * hashCode + (this.actionTypeString() == null ? 0 : this.actionTypeString().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyEnvironmentManagedActionResponse)) {
            return false;
        }
        ApplyEnvironmentManagedActionResponse other = (ApplyEnvironmentManagedActionResponse)((Object)obj);
        if (other.actionId() == null ^ this.actionId() == null) {
            return false;
        }
        if (other.actionId() != null && !other.actionId().equals(this.actionId())) {
            return false;
        }
        if (other.actionDescription() == null ^ this.actionDescription() == null) {
            return false;
        }
        if (other.actionDescription() != null && !other.actionDescription().equals(this.actionDescription())) {
            return false;
        }
        if (other.actionTypeString() == null ^ this.actionTypeString() == null) {
            return false;
        }
        if (other.actionTypeString() != null && !other.actionTypeString().equals(this.actionTypeString())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionId() != null) {
            sb.append("ActionId: ").append(this.actionId()).append(",");
        }
        if (this.actionDescription() != null) {
            sb.append("ActionDescription: ").append(this.actionDescription()).append(",");
        }
        if (this.actionTypeString() != null) {
            sb.append("ActionType: ").append(this.actionTypeString()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.of(clazz.cast(this.actionId()));
            }
            case "ActionDescription": {
                return Optional.of(clazz.cast(this.actionDescription()));
            }
            case "ActionType": {
                return Optional.of(clazz.cast(this.actionTypeString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String actionDescription;
        private String actionType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyEnvironmentManagedActionResponse model) {
            this.actionId(model.actionId);
            this.actionDescription(model.actionDescription);
            this.actionType(model.actionType);
            this.status(model.status);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ApplyEnvironmentManagedActionResponse build() {
            return new ApplyEnvironmentManagedActionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplyEnvironmentManagedActionResponse> {
        public Builder actionId(String var1);

        public Builder actionDescription(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder status(String var1);
    }
}

