/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ValidateConfigurationSettingsRequestMarshaller
implements Marshaller<Request<ValidateConfigurationSettingsRequest>, ValidateConfigurationSettingsRequest> {
    public Request<ValidateConfigurationSettingsRequest> marshall(ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) {
        List<ConfigurationOptionSetting> optionSettingsList;
        if (validateConfigurationSettingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)validateConfigurationSettingsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ValidateConfigurationSettings");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (validateConfigurationSettingsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)validateConfigurationSettingsRequest.applicationName()));
        }
        if (validateConfigurationSettingsRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)validateConfigurationSettingsRequest.templateName()));
        }
        if (validateConfigurationSettingsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)validateConfigurationSettingsRequest.environmentName()));
        }
        if ((optionSettingsList = validateConfigurationSettingsRequest.optionSettings()) != null) {
            if (!optionSettingsList.isEmpty()) {
                int optionSettingsListIndex = 1;
                for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                    if (optionSettingsListValue.resourceName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.resourceName()));
                    }
                    if (optionSettingsListValue.namespace() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.namespace()));
                    }
                    if (optionSettingsListValue.optionName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.optionName()));
                    }
                    if (optionSettingsListValue.value() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.value()));
                    }
                    ++optionSettingsListIndex;
                }
            } else {
                request.addParameter("OptionSettings", "");
            }
        }
        return request;
    }
}

