/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;

public class EnvironmentTierUnmarshaller
implements Unmarshaller<EnvironmentTier, StaxUnmarshallerContext> {
    private static final EnvironmentTierUnmarshaller INSTANCE = new EnvironmentTierUnmarshaller();

    public EnvironmentTier unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EnvironmentTier.Builder environmentTier = EnvironmentTier.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    environmentTier.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Type", targetDepth)) {
                    environmentTier.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Version", targetDepth)) continue;
                environmentTier.version(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EnvironmentTier)environmentTier.build();
    }

    public static EnvironmentTierUnmarshaller getInstance() {
        return INSTANCE;
    }
}

