/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule;
import software.amazon.awssdk.services.elasticbeanstalk.model.MaxCountRule;
import software.amazon.awssdk.util.StringUtils;

public class CreateApplicationRequestMarshaller
implements Marshaller<Request<CreateApplicationRequest>, CreateApplicationRequest> {
    public Request<CreateApplicationRequest> marshall(CreateApplicationRequest createApplicationRequest) {
        ApplicationResourceLifecycleConfig resourceLifecycleConfig;
        if (createApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createApplicationRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreateApplication");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createApplicationRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createApplicationRequest.applicationName()));
        }
        if (createApplicationRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createApplicationRequest.description()));
        }
        if ((resourceLifecycleConfig = createApplicationRequest.resourceLifecycleConfig()) != null) {
            ApplicationVersionLifecycleConfig versionLifecycleConfig;
            if (resourceLifecycleConfig.serviceRole() != null) {
                request.addParameter("ResourceLifecycleConfig.ServiceRole", StringUtils.fromString((String)resourceLifecycleConfig.serviceRole()));
            }
            if ((versionLifecycleConfig = resourceLifecycleConfig.versionLifecycleConfig()) != null) {
                MaxAgeRule maxAgeRule;
                MaxCountRule maxCountRule = versionLifecycleConfig.maxCountRule();
                if (maxCountRule != null) {
                    if (maxCountRule.enabled() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.Enabled", StringUtils.fromBoolean((Boolean)maxCountRule.enabled()));
                    }
                    if (maxCountRule.maxCount() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.MaxCount", StringUtils.fromInteger((Integer)maxCountRule.maxCount()));
                    }
                    if (maxCountRule.deleteSourceFromS3() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.DeleteSourceFromS3", StringUtils.fromBoolean((Boolean)maxCountRule.deleteSourceFromS3()));
                    }
                }
                if ((maxAgeRule = versionLifecycleConfig.maxAgeRule()) != null) {
                    if (maxAgeRule.enabled() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.Enabled", StringUtils.fromBoolean((Boolean)maxAgeRule.enabled()));
                    }
                    if (maxAgeRule.maxAgeInDays() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.MaxAgeInDays", StringUtils.fromInteger((Integer)maxAgeRule.maxAgeInDays()));
                    }
                    if (maxAgeRule.deleteSourceFromS3() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.DeleteSourceFromS3", StringUtils.fromBoolean((Boolean)maxAgeRule.deleteSourceFromS3()));
                    }
                }
            }
        }
        return request;
    }
}

