/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescriptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEnvironmentsResponse> {
    private final List<EnvironmentDescription> environments;

    private DescribeEnvironmentsResponse(BuilderImpl builder) {
        this.environments = builder.environments;
    }

    public List<EnvironmentDescription> environments() {
        return this.environments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environments() == null ? 0 : this.environments().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsResponse)) {
            return false;
        }
        DescribeEnvironmentsResponse other = (DescribeEnvironmentsResponse)((Object)obj);
        if (other.environments() == null ^ this.environments() == null) {
            return false;
        }
        return other.environments() == null || other.environments().equals(this.environments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.environments() != null) {
            sb.append("Environments: ").append(this.environments()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EnvironmentDescription> environments;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsResponse model) {
            this.setEnvironments(model.environments);
        }

        public final Collection<EnvironmentDescription> getEnvironments() {
            return this.environments;
        }

        @Override
        public final Builder environments(Collection<EnvironmentDescription> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(EnvironmentDescription ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        public final void setEnvironments(Collection<EnvironmentDescription> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copy(environments);
        }

        public DescribeEnvironmentsResponse build() {
            return new DescribeEnvironmentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEnvironmentsResponse> {
        public Builder environments(Collection<EnvironmentDescription> var1);

        public Builder environments(EnvironmentDescription ... var1);
    }
}

