/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedAction;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentManagedActionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEnvironmentManagedActionsResponse> {
    private final List<ManagedAction> managedActions;

    private DescribeEnvironmentManagedActionsResponse(BuilderImpl builder) {
        this.managedActions = builder.managedActions;
    }

    public List<ManagedAction> managedActions() {
        return this.managedActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.managedActions() == null ? 0 : this.managedActions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionsResponse)) {
            return false;
        }
        DescribeEnvironmentManagedActionsResponse other = (DescribeEnvironmentManagedActionsResponse)((Object)obj);
        if (other.managedActions() == null ^ this.managedActions() == null) {
            return false;
        }
        return other.managedActions() == null || other.managedActions().equals(this.managedActions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.managedActions() != null) {
            sb.append("ManagedActions: ").append(this.managedActions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ManagedAction> managedActions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionsResponse model) {
            this.setManagedActions(model.managedActions);
        }

        public final Collection<ManagedAction> getManagedActions() {
            return this.managedActions;
        }

        @Override
        public final Builder managedActions(Collection<ManagedAction> managedActions) {
            this.managedActions = ManagedActionsCopier.copy(managedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActions(ManagedAction ... managedActions) {
            this.managedActions(Arrays.asList(managedActions));
            return this;
        }

        public final void setManagedActions(Collection<ManagedAction> managedActions) {
            this.managedActions = ManagedActionsCopier.copy(managedActions);
        }

        public DescribeEnvironmentManagedActionsResponse build() {
            return new DescribeEnvironmentManagedActionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEnvironmentManagedActionsResponse> {
        public Builder managedActions(Collection<ManagedAction> var1);

        public Builder managedActions(ManagedAction ... var1);
    }
}

