/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationNamesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeApplicationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeApplicationsRequest> {
    private final List<String> applicationNames;

    private DescribeApplicationsRequest(BuilderImpl builder) {
        this.applicationNames = builder.applicationNames;
    }

    public List<String> applicationNames() {
        return this.applicationNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationNames() == null ? 0 : this.applicationNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsRequest)) {
            return false;
        }
        DescribeApplicationsRequest other = (DescribeApplicationsRequest)((Object)obj);
        if (other.applicationNames() == null ^ this.applicationNames() == null) {
            return false;
        }
        return other.applicationNames() == null || other.applicationNames().equals(this.applicationNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationNames() != null) {
            sb.append("ApplicationNames: ").append(this.applicationNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> applicationNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsRequest model) {
            this.setApplicationNames(model.applicationNames);
        }

        public final Collection<String> getApplicationNames() {
            return this.applicationNames;
        }

        @Override
        public final Builder applicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationNamesListCopier.copy(applicationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationNames(String ... applicationNames) {
            this.applicationNames(Arrays.asList(applicationNames));
            return this;
        }

        public final void setApplicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationNamesListCopier.copy(applicationNames);
        }

        public DescribeApplicationsRequest build() {
            return new DescribeApplicationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeApplicationsRequest> {
        public Builder applicationNames(Collection<String> var1);

        public Builder applicationNames(String ... var1);
    }
}

