/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Deployment
implements ToCopyableBuilder<Builder, Deployment> {
    private final String versionLabel;
    private final Long deploymentId;
    private final String status;
    private final Instant deploymentTime;

    private Deployment(BuilderImpl builder) {
        this.versionLabel = builder.versionLabel;
        this.deploymentId = builder.deploymentId;
        this.status = builder.status;
        this.deploymentTime = builder.deploymentTime;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public Long deploymentId() {
        return this.deploymentId;
    }

    public String status() {
        return this.status;
    }

    public Instant deploymentTime() {
        return this.deploymentTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.deploymentId() == null ? 0 : this.deploymentId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.deploymentTime() == null ? 0 : this.deploymentTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.deploymentTime() == null ^ this.deploymentTime() == null) {
            return false;
        }
        return other.deploymentTime() == null || other.deploymentTime().equals(this.deploymentTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.deploymentTime() != null) {
            sb.append("DeploymentTime: ").append(this.deploymentTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String versionLabel;
        private Long deploymentId;
        private String status;
        private Instant deploymentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.setVersionLabel(model.versionLabel);
            this.setDeploymentId(model.deploymentId);
            this.setStatus(model.status);
            this.setDeploymentTime(model.deploymentTime);
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final Long getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(Long deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(Long deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getDeploymentTime() {
            return this.deploymentTime;
        }

        @Override
        public final Builder deploymentTime(Instant deploymentTime) {
            this.deploymentTime = deploymentTime;
            return this;
        }

        public final void setDeploymentTime(Instant deploymentTime) {
            this.deploymentTime = deploymentTime;
        }

        public Deployment build() {
            return new Deployment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Deployment> {
        public Builder versionLabel(String var1);

        public Builder deploymentId(Long var1);

        public Builder status(String var1);

        public Builder deploymentTime(Instant var1);
    }
}

