/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateConfigurationTemplateResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateConfigurationTemplateResponse> {
    private final String solutionStackName;
    private final String platformArn;
    private final String applicationName;
    private final String templateName;
    private final String description;
    private final String environmentName;
    private final String deploymentStatus;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final List<ConfigurationOptionSetting> optionSettings;

    private CreateConfigurationTemplateResponse(BuilderImpl builder) {
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.environmentName = builder.environmentName;
        this.deploymentStatus = builder.deploymentStatus;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.optionSettings = builder.optionSettings;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String templateName() {
        return this.templateName;
    }

    public String description() {
        return this.description;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String deploymentStatus() {
        return this.deploymentStatus;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateUpdated() {
        return this.dateUpdated;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.solutionStackName() == null ? 0 : this.solutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.templateName() == null ? 0 : this.templateName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentStatus() == null ? 0 : this.deploymentStatus().hashCode());
        hashCode = 31 * hashCode + (this.dateCreated() == null ? 0 : this.dateCreated().hashCode());
        hashCode = 31 * hashCode + (this.dateUpdated() == null ? 0 : this.dateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.optionSettings() == null ? 0 : this.optionSettings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationTemplateResponse)) {
            return false;
        }
        CreateConfigurationTemplateResponse other = (CreateConfigurationTemplateResponse)((Object)obj);
        if (other.solutionStackName() == null ^ this.solutionStackName() == null) {
            return false;
        }
        if (other.solutionStackName() != null && !other.solutionStackName().equals(this.solutionStackName())) {
            return false;
        }
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.templateName() == null ^ this.templateName() == null) {
            return false;
        }
        if (other.templateName() != null && !other.templateName().equals(this.templateName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.deploymentStatus() == null ^ this.deploymentStatus() == null) {
            return false;
        }
        if (other.deploymentStatus() != null && !other.deploymentStatus().equals(this.deploymentStatus())) {
            return false;
        }
        if (other.dateCreated() == null ^ this.dateCreated() == null) {
            return false;
        }
        if (other.dateCreated() != null && !other.dateCreated().equals(this.dateCreated())) {
            return false;
        }
        if (other.dateUpdated() == null ^ this.dateUpdated() == null) {
            return false;
        }
        if (other.dateUpdated() != null && !other.dateUpdated().equals(this.dateUpdated())) {
            return false;
        }
        if (other.optionSettings() == null ^ this.optionSettings() == null) {
            return false;
        }
        return other.optionSettings() == null || other.optionSettings().equals(this.optionSettings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.deploymentStatus() != null) {
            sb.append("DeploymentStatus: ").append(this.deploymentStatus()).append(",");
        }
        if (this.dateCreated() != null) {
            sb.append("DateCreated: ").append(this.dateCreated()).append(",");
        }
        if (this.dateUpdated() != null) {
            sb.append("DateUpdated: ").append(this.dateUpdated()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String solutionStackName;
        private String platformArn;
        private String applicationName;
        private String templateName;
        private String description;
        private String environmentName;
        private String deploymentStatus;
        private Instant dateCreated;
        private Instant dateUpdated;
        private List<ConfigurationOptionSetting> optionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationTemplateResponse model) {
            this.setSolutionStackName(model.solutionStackName);
            this.setPlatformArn(model.platformArn);
            this.setApplicationName(model.applicationName);
            this.setTemplateName(model.templateName);
            this.setDescription(model.description);
            this.setEnvironmentName(model.environmentName);
            this.setDeploymentStatus(model.deploymentStatus);
            this.setDateCreated(model.dateCreated);
            this.setDateUpdated(model.dateUpdated);
            this.setOptionSettings(model.optionSettings);
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(ConfigurationDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final Collection<ConfigurationOptionSetting> getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
        }

        public CreateConfigurationTemplateResponse build() {
            return new CreateConfigurationTemplateResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateConfigurationTemplateResponse> {
        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder environmentName(String var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(ConfigurationDeploymentStatus var1);

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);
    }
}

