/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.VersionLabelsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComposeEnvironmentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ComposeEnvironmentsRequest> {
    private final String applicationName;
    private final String groupName;
    private final List<String> versionLabels;

    private ComposeEnvironmentsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.groupName = builder.groupName;
        this.versionLabels = builder.versionLabels;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String groupName() {
        return this.groupName;
    }

    public List<String> versionLabels() {
        return this.versionLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.versionLabels() == null ? 0 : this.versionLabels().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComposeEnvironmentsRequest)) {
            return false;
        }
        ComposeEnvironmentsRequest other = (ComposeEnvironmentsRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.versionLabels() == null ^ this.versionLabels() == null) {
            return false;
        }
        return other.versionLabels() == null || other.versionLabels().equals(this.versionLabels());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.versionLabels() != null) {
            sb.append("VersionLabels: ").append(this.versionLabels()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String groupName;
        private List<String> versionLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(ComposeEnvironmentsRequest model) {
            this.setApplicationName(model.applicationName);
            this.setGroupName(model.groupName);
            this.setVersionLabels(model.versionLabels);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<String> getVersionLabels() {
            return this.versionLabels;
        }

        @Override
        public final Builder versionLabels(Collection<String> versionLabels) {
            this.versionLabels = VersionLabelsCopier.copy(versionLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionLabels(String ... versionLabels) {
            this.versionLabels(Arrays.asList(versionLabels));
            return this;
        }

        public final void setVersionLabels(Collection<String> versionLabels) {
            this.versionLabels = VersionLabelsCopier.copy(versionLabels);
        }

        public ComposeEnvironmentsRequest build() {
            return new ComposeEnvironmentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComposeEnvironmentsRequest> {
        public Builder applicationName(String var1);

        public Builder groupName(String var1);

        public Builder versionLabels(Collection<String> var1);

        public Builder versionLabels(String ... var1);
    }
}

