/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CPUUtilization
implements ToCopyableBuilder<Builder, CPUUtilization> {
    private final Double user;
    private final Double nice;
    private final Double system;
    private final Double idle;
    private final Double ioWait;
    private final Double irq;
    private final Double softIRQ;

    private CPUUtilization(BuilderImpl builder) {
        this.user = builder.user;
        this.nice = builder.nice;
        this.system = builder.system;
        this.idle = builder.idle;
        this.ioWait = builder.ioWait;
        this.irq = builder.irq;
        this.softIRQ = builder.softIRQ;
    }

    public Double user() {
        return this.user;
    }

    public Double nice() {
        return this.nice;
    }

    public Double system() {
        return this.system;
    }

    public Double idle() {
        return this.idle;
    }

    public Double ioWait() {
        return this.ioWait;
    }

    public Double irq() {
        return this.irq;
    }

    public Double softIRQ() {
        return this.softIRQ;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.user() == null ? 0 : this.user().hashCode());
        hashCode = 31 * hashCode + (this.nice() == null ? 0 : this.nice().hashCode());
        hashCode = 31 * hashCode + (this.system() == null ? 0 : this.system().hashCode());
        hashCode = 31 * hashCode + (this.idle() == null ? 0 : this.idle().hashCode());
        hashCode = 31 * hashCode + (this.ioWait() == null ? 0 : this.ioWait().hashCode());
        hashCode = 31 * hashCode + (this.irq() == null ? 0 : this.irq().hashCode());
        hashCode = 31 * hashCode + (this.softIRQ() == null ? 0 : this.softIRQ().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPUUtilization)) {
            return false;
        }
        CPUUtilization other = (CPUUtilization)obj;
        if (other.user() == null ^ this.user() == null) {
            return false;
        }
        if (other.user() != null && !other.user().equals(this.user())) {
            return false;
        }
        if (other.nice() == null ^ this.nice() == null) {
            return false;
        }
        if (other.nice() != null && !other.nice().equals(this.nice())) {
            return false;
        }
        if (other.system() == null ^ this.system() == null) {
            return false;
        }
        if (other.system() != null && !other.system().equals(this.system())) {
            return false;
        }
        if (other.idle() == null ^ this.idle() == null) {
            return false;
        }
        if (other.idle() != null && !other.idle().equals(this.idle())) {
            return false;
        }
        if (other.ioWait() == null ^ this.ioWait() == null) {
            return false;
        }
        if (other.ioWait() != null && !other.ioWait().equals(this.ioWait())) {
            return false;
        }
        if (other.irq() == null ^ this.irq() == null) {
            return false;
        }
        if (other.irq() != null && !other.irq().equals(this.irq())) {
            return false;
        }
        if (other.softIRQ() == null ^ this.softIRQ() == null) {
            return false;
        }
        return other.softIRQ() == null || other.softIRQ().equals(this.softIRQ());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.user() != null) {
            sb.append("User: ").append(this.user()).append(",");
        }
        if (this.nice() != null) {
            sb.append("Nice: ").append(this.nice()).append(",");
        }
        if (this.system() != null) {
            sb.append("System: ").append(this.system()).append(",");
        }
        if (this.idle() != null) {
            sb.append("Idle: ").append(this.idle()).append(",");
        }
        if (this.ioWait() != null) {
            sb.append("IOWait: ").append(this.ioWait()).append(",");
        }
        if (this.irq() != null) {
            sb.append("IRQ: ").append(this.irq()).append(",");
        }
        if (this.softIRQ() != null) {
            sb.append("SoftIRQ: ").append(this.softIRQ()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Double user;
        private Double nice;
        private Double system;
        private Double idle;
        private Double ioWait;
        private Double irq;
        private Double softIRQ;

        private BuilderImpl() {
        }

        private BuilderImpl(CPUUtilization model) {
            this.setUser(model.user);
            this.setNice(model.nice);
            this.setSystem(model.system);
            this.setIdle(model.idle);
            this.setIOWait(model.ioWait);
            this.setIRQ(model.irq);
            this.setSoftIRQ(model.softIRQ);
        }

        public final Double getUser() {
            return this.user;
        }

        @Override
        public final Builder user(Double user) {
            this.user = user;
            return this;
        }

        public final void setUser(Double user) {
            this.user = user;
        }

        public final Double getNice() {
            return this.nice;
        }

        @Override
        public final Builder nice(Double nice) {
            this.nice = nice;
            return this;
        }

        public final void setNice(Double nice) {
            this.nice = nice;
        }

        public final Double getSystem() {
            return this.system;
        }

        @Override
        public final Builder system(Double system) {
            this.system = system;
            return this;
        }

        public final void setSystem(Double system) {
            this.system = system;
        }

        public final Double getIdle() {
            return this.idle;
        }

        @Override
        public final Builder idle(Double idle) {
            this.idle = idle;
            return this;
        }

        public final void setIdle(Double idle) {
            this.idle = idle;
        }

        public final Double getIOWait() {
            return this.ioWait;
        }

        @Override
        public final Builder ioWait(Double ioWait) {
            this.ioWait = ioWait;
            return this;
        }

        public final void setIOWait(Double ioWait) {
            this.ioWait = ioWait;
        }

        public final Double getIRQ() {
            return this.irq;
        }

        @Override
        public final Builder irq(Double irq) {
            this.irq = irq;
            return this;
        }

        public final void setIRQ(Double irq) {
            this.irq = irq;
        }

        public final Double getSoftIRQ() {
            return this.softIRQ;
        }

        @Override
        public final Builder softIRQ(Double softIRQ) {
            this.softIRQ = softIRQ;
            return this;
        }

        public final void setSoftIRQ(Double softIRQ) {
            this.softIRQ = softIRQ;
        }

        public CPUUtilization build() {
            return new CPUUtilization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CPUUtilization> {
        public Builder user(Double var1);

        public Builder nice(Double var1);

        public Builder system(Double var1);

        public Builder idle(Double var1);

        public Builder ioWait(Double var1);

        public Builder irq(Double var1);

        public Builder softIRQ(Double var1);
    }
}

