/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import software.amazon.awssdk.util.StringUtils;

public class RebuildEnvironmentRequestMarshaller
implements Marshaller<Request<RebuildEnvironmentRequest>, RebuildEnvironmentRequest> {
    public Request<RebuildEnvironmentRequest> marshall(RebuildEnvironmentRequest rebuildEnvironmentRequest) {
        if (rebuildEnvironmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebuildEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RebuildEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebuildEnvironmentRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)rebuildEnvironmentRequest.environmentId()));
        }
        if (rebuildEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)rebuildEnvironmentRequest.environmentName()));
        }
        return request;
    }
}

