/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.util.StringUtils;

public class DescribeConfigurationOptionsRequestMarshaller
implements Marshaller<Request<DescribeConfigurationOptionsRequest>, DescribeConfigurationOptionsRequest> {
    public Request<DescribeConfigurationOptionsRequest> marshall(DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) {
        List<OptionSpecification> optionsList;
        if (describeConfigurationOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConfigurationOptionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeConfigurationOptions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationOptionsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeConfigurationOptionsRequest.applicationName()));
        }
        if (describeConfigurationOptionsRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)describeConfigurationOptionsRequest.templateName()));
        }
        if (describeConfigurationOptionsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeConfigurationOptionsRequest.environmentName()));
        }
        if (describeConfigurationOptionsRequest.solutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString((String)describeConfigurationOptionsRequest.solutionStackName()));
        }
        if (describeConfigurationOptionsRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringUtils.fromString((String)describeConfigurationOptionsRequest.platformArn()));
        }
        if ((optionsList = describeConfigurationOptionsRequest.options()) != null) {
            if (!optionsList.isEmpty()) {
                int optionsListIndex = 1;
                for (OptionSpecification optionsListValue : optionsList) {
                    if (optionsListValue.resourceName() != null) {
                        request.addParameter("Options.member." + optionsListIndex + ".ResourceName", StringUtils.fromString((String)optionsListValue.resourceName()));
                    }
                    if (optionsListValue.namespace() != null) {
                        request.addParameter("Options.member." + optionsListIndex + ".Namespace", StringUtils.fromString((String)optionsListValue.namespace()));
                    }
                    if (optionsListValue.optionName() != null) {
                        request.addParameter("Options.member." + optionsListIndex + ".OptionName", StringUtils.fromString((String)optionsListValue.optionName()));
                    }
                    ++optionsListIndex;
                }
            } else {
                request.addParameter("Options", "");
            }
        }
        return request;
    }
}

