/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest;
import software.amazon.awssdk.util.StringUtils;

public class CheckDNSAvailabilityRequestMarshaller
implements Marshaller<Request<CheckDNSAvailabilityRequest>, CheckDNSAvailabilityRequest> {
    public Request<CheckDNSAvailabilityRequest> marshall(CheckDNSAvailabilityRequest checkDNSAvailabilityRequest) {
        if (checkDNSAvailabilityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)checkDNSAvailabilityRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CheckDNSAvailability");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (checkDNSAvailabilityRequest.cnamePrefix() != null) {
            request.addParameter("CNAMEPrefix", StringUtils.fromString((String)checkDNSAvailabilityRequest.cnamePrefix()));
        }
        return request;
    }
}

