/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RetrieveEnvironmentInfoResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, RetrieveEnvironmentInfoResponse> {
    private final List<EnvironmentInfoDescription> environmentInfo;

    private RetrieveEnvironmentInfoResponse(BuilderImpl builder) {
        this.environmentInfo = builder.environmentInfo;
    }

    public List<EnvironmentInfoDescription> environmentInfo() {
        return this.environmentInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentInfo() == null ? 0 : this.environmentInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveEnvironmentInfoResponse)) {
            return false;
        }
        RetrieveEnvironmentInfoResponse other = (RetrieveEnvironmentInfoResponse)((Object)obj);
        if (other.environmentInfo() == null ^ this.environmentInfo() == null) {
            return false;
        }
        return other.environmentInfo() == null || other.environmentInfo().equals(this.environmentInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.environmentInfo() != null) {
            sb.append("EnvironmentInfo: ").append(this.environmentInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EnvironmentInfoDescription> environmentInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveEnvironmentInfoResponse model) {
            this.setEnvironmentInfo(model.environmentInfo);
        }

        public final Collection<EnvironmentInfoDescription> getEnvironmentInfo() {
            return this.environmentInfo;
        }

        @Override
        public final Builder environmentInfo(Collection<EnvironmentInfoDescription> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copy(environmentInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInfo(EnvironmentInfoDescription ... environmentInfo) {
            this.environmentInfo(Arrays.asList(environmentInfo));
            return this;
        }

        public final void setEnvironmentInfo(Collection<EnvironmentInfoDescription> environmentInfo) {
            this.environmentInfo = EnvironmentInfoDescriptionListCopier.copy(environmentInfo);
        }

        @SafeVarargs
        public final void setEnvironmentInfo(EnvironmentInfoDescription ... environmentInfo) {
            this.environmentInfo(Arrays.asList(environmentInfo));
        }

        public RetrieveEnvironmentInfoResponse build() {
            return new RetrieveEnvironmentInfoResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RetrieveEnvironmentInfoResponse> {
        public Builder environmentInfo(Collection<EnvironmentInfoDescription> var1);

        public Builder environmentInfo(EnvironmentInfoDescription ... var1);
    }
}

