/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilterValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlatformFilter
implements ToCopyableBuilder<Builder, PlatformFilter> {
    private final String type;
    private final String operator;
    private final List<String> values;

    private PlatformFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public String type() {
        return this.type;
    }

    public String operator() {
        return this.operator;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.operator() == null ? 0 : this.operator().hashCode());
        hashCode = 31 * hashCode + (this.values() == null ? 0 : this.values().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformFilter)) {
            return false;
        }
        PlatformFilter other = (PlatformFilter)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.operator() == null ^ this.operator() == null) {
            return false;
        }
        if (other.operator() != null && !other.operator().equals(this.operator())) {
            return false;
        }
        if (other.values() == null ^ this.values() == null) {
            return false;
        }
        return other.values() == null || other.values().equals(this.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.operator() != null) {
            sb.append("Operator: ").append(this.operator()).append(",");
        }
        if (this.values() != null) {
            sb.append("Values: ").append(this.values()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String operator;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformFilter model) {
            this.setType(model.type);
            this.setOperator(model.operator);
            this.setValues(model.values);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOperator() {
            return this.operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = PlatformFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = PlatformFilterValueListCopier.copy(values);
        }

        @SafeVarargs
        public final void setValues(String ... values) {
            this.values(Arrays.asList(values));
        }

        public PlatformFilter build() {
            return new PlatformFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlatformFilter> {
        public Builder type(String var1);

        public Builder operator(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

