/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.services.elasticbeanstalk.model.FailureType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ManagedActionHistoryItem
implements ToCopyableBuilder<Builder, ManagedActionHistoryItem> {
    private final String actionId;
    private final String actionType;
    private final String actionDescription;
    private final String failureType;
    private final String status;
    private final String failureDescription;
    private final Instant executedTime;
    private final Instant finishedTime;

    private ManagedActionHistoryItem(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionType = builder.actionType;
        this.actionDescription = builder.actionDescription;
        this.failureType = builder.failureType;
        this.status = builder.status;
        this.failureDescription = builder.failureDescription;
        this.executedTime = builder.executedTime;
        this.finishedTime = builder.finishedTime;
    }

    public String actionId() {
        return this.actionId;
    }

    public String actionType() {
        return this.actionType;
    }

    public String actionDescription() {
        return this.actionDescription;
    }

    public String failureType() {
        return this.failureType;
    }

    public String status() {
        return this.status;
    }

    public String failureDescription() {
        return this.failureDescription;
    }

    public Instant executedTime() {
        return this.executedTime;
    }

    public Instant finishedTime() {
        return this.finishedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionId() == null ? 0 : this.actionId().hashCode());
        hashCode = 31 * hashCode + (this.actionType() == null ? 0 : this.actionType().hashCode());
        hashCode = 31 * hashCode + (this.actionDescription() == null ? 0 : this.actionDescription().hashCode());
        hashCode = 31 * hashCode + (this.failureType() == null ? 0 : this.failureType().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.failureDescription() == null ? 0 : this.failureDescription().hashCode());
        hashCode = 31 * hashCode + (this.executedTime() == null ? 0 : this.executedTime().hashCode());
        hashCode = 31 * hashCode + (this.finishedTime() == null ? 0 : this.finishedTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedActionHistoryItem)) {
            return false;
        }
        ManagedActionHistoryItem other = (ManagedActionHistoryItem)obj;
        if (other.actionId() == null ^ this.actionId() == null) {
            return false;
        }
        if (other.actionId() != null && !other.actionId().equals(this.actionId())) {
            return false;
        }
        if (other.actionType() == null ^ this.actionType() == null) {
            return false;
        }
        if (other.actionType() != null && !other.actionType().equals(this.actionType())) {
            return false;
        }
        if (other.actionDescription() == null ^ this.actionDescription() == null) {
            return false;
        }
        if (other.actionDescription() != null && !other.actionDescription().equals(this.actionDescription())) {
            return false;
        }
        if (other.failureType() == null ^ this.failureType() == null) {
            return false;
        }
        if (other.failureType() != null && !other.failureType().equals(this.failureType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.failureDescription() == null ^ this.failureDescription() == null) {
            return false;
        }
        if (other.failureDescription() != null && !other.failureDescription().equals(this.failureDescription())) {
            return false;
        }
        if (other.executedTime() == null ^ this.executedTime() == null) {
            return false;
        }
        if (other.executedTime() != null && !other.executedTime().equals(this.executedTime())) {
            return false;
        }
        if (other.finishedTime() == null ^ this.finishedTime() == null) {
            return false;
        }
        return other.finishedTime() == null || other.finishedTime().equals(this.finishedTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actionId() != null) {
            sb.append("ActionId: ").append(this.actionId()).append(",");
        }
        if (this.actionType() != null) {
            sb.append("ActionType: ").append(this.actionType()).append(",");
        }
        if (this.actionDescription() != null) {
            sb.append("ActionDescription: ").append(this.actionDescription()).append(",");
        }
        if (this.failureType() != null) {
            sb.append("FailureType: ").append(this.failureType()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.failureDescription() != null) {
            sb.append("FailureDescription: ").append(this.failureDescription()).append(",");
        }
        if (this.executedTime() != null) {
            sb.append("ExecutedTime: ").append(this.executedTime()).append(",");
        }
        if (this.finishedTime() != null) {
            sb.append("FinishedTime: ").append(this.finishedTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String actionType;
        private String actionDescription;
        private String failureType;
        private String status;
        private String failureDescription;
        private Instant executedTime;
        private Instant finishedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedActionHistoryItem model) {
            this.setActionId(model.actionId);
            this.setActionType(model.actionType);
            this.setActionDescription(model.actionDescription);
            this.setFailureType(model.failureType);
            this.setStatus(model.status);
            this.setFailureDescription(model.failureDescription);
            this.setExecutedTime(model.executedTime);
            this.setFinishedTime(model.finishedTime);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final void setActionType(ActionType actionType) {
            this.actionType(actionType.toString());
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getFailureType() {
            return this.failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(FailureType failureType) {
            this.failureType(failureType.toString());
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final void setFailureType(FailureType failureType) {
            this.failureType(failureType.toString());
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionHistoryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ActionHistoryStatus status) {
            this.status(status.toString());
        }

        public final String getFailureDescription() {
            return this.failureDescription;
        }

        @Override
        public final Builder failureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        public final void setFailureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        public final Instant getExecutedTime() {
            return this.executedTime;
        }

        @Override
        public final Builder executedTime(Instant executedTime) {
            this.executedTime = executedTime;
            return this;
        }

        public final void setExecutedTime(Instant executedTime) {
            this.executedTime = executedTime;
        }

        public final Instant getFinishedTime() {
            return this.finishedTime;
        }

        @Override
        public final Builder finishedTime(Instant finishedTime) {
            this.finishedTime = finishedTime;
            return this;
        }

        public final void setFinishedTime(Instant finishedTime) {
            this.finishedTime = finishedTime;
        }

        public ManagedActionHistoryItem build() {
            return new ManagedActionHistoryItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ManagedActionHistoryItem> {
        public Builder actionId(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder actionDescription(String var1);

        public Builder failureType(String var1);

        public Builder failureType(FailureType var1);

        public Builder status(String var1);

        public Builder status(ActionHistoryStatus var1);

        public Builder failureDescription(String var1);

        public Builder executedTime(Instant var1);

        public Builder finishedTime(Instant var1);
    }
}

