/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest;

public class UpdateEnvironmentRequestMarshaller
implements Marshaller<Request<UpdateEnvironmentRequest>, UpdateEnvironmentRequest> {
    public Request<UpdateEnvironmentRequest> marshall(UpdateEnvironmentRequest updateEnvironmentRequest) {
        EnvironmentTier tier;
        if (updateEnvironmentRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateEnvironmentRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)updateEnvironmentRequest.applicationName()));
        }
        if (updateEnvironmentRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)updateEnvironmentRequest.environmentId()));
        }
        if (updateEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)updateEnvironmentRequest.environmentName()));
        }
        if (updateEnvironmentRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)updateEnvironmentRequest.groupName()));
        }
        if (updateEnvironmentRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)updateEnvironmentRequest.description()));
        }
        if ((tier = updateEnvironmentRequest.tier()) != null) {
            if (tier.name() != null) {
                request.addParameter("Tier.Name", StringConversion.fromString((String)tier.name()));
            }
            if (tier.type() != null) {
                request.addParameter("Tier.Type", StringConversion.fromString((String)tier.type()));
            }
            if (tier.version() != null) {
                request.addParameter("Tier.Version", StringConversion.fromString((String)tier.version()));
            }
        }
        if (updateEnvironmentRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringConversion.fromString((String)updateEnvironmentRequest.versionLabel()));
        }
        if (updateEnvironmentRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)updateEnvironmentRequest.templateName()));
        }
        if (updateEnvironmentRequest.solutionStackName() != null) {
            request.addParameter("SolutionStackName", StringConversion.fromString((String)updateEnvironmentRequest.solutionStackName()));
        }
        if (updateEnvironmentRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringConversion.fromString((String)updateEnvironmentRequest.platformArn()));
        }
        if (updateEnvironmentRequest.optionSettings().isEmpty() && !(updateEnvironmentRequest.optionSettings() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionSettings", "");
        } else if (!updateEnvironmentRequest.optionSettings().isEmpty() && !(updateEnvironmentRequest.optionSettings() instanceof SdkAutoConstructList)) {
            List<ConfigurationOptionSetting> optionSettingsList = updateEnvironmentRequest.optionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.resourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringConversion.fromString((String)optionSettingsListValue.resourceName()));
                }
                if (optionSettingsListValue.namespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringConversion.fromString((String)optionSettingsListValue.namespace()));
                }
                if (optionSettingsListValue.optionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringConversion.fromString((String)optionSettingsListValue.optionName()));
                }
                if (optionSettingsListValue.value() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringConversion.fromString((String)optionSettingsListValue.value()));
                }
                ++optionSettingsListIndex;
            }
        }
        if (updateEnvironmentRequest.optionsToRemove().isEmpty() && !(updateEnvironmentRequest.optionsToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionsToRemove", "");
        } else if (!updateEnvironmentRequest.optionsToRemove().isEmpty() && !(updateEnvironmentRequest.optionsToRemove() instanceof SdkAutoConstructList)) {
            List<OptionSpecification> optionsToRemoveList = updateEnvironmentRequest.optionsToRemove();
            int optionsToRemoveListIndex = 1;
            for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue.resourceName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".ResourceName", StringConversion.fromString((String)optionsToRemoveListValue.resourceName()));
                }
                if (optionsToRemoveListValue.namespace() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringConversion.fromString((String)optionsToRemoveListValue.namespace()));
                }
                if (optionsToRemoveListValue.optionName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringConversion.fromString((String)optionsToRemoveListValue.optionName()));
                }
                ++optionsToRemoveListIndex;
            }
        }
        return request;
    }
}

