/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;

public class UpdateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<UpdateConfigurationTemplateRequest>, UpdateConfigurationTemplateRequest> {
    public Request<UpdateConfigurationTemplateRequest> marshall(UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) {
        if (updateConfigurationTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateConfigurationTemplateRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateConfigurationTemplateRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)updateConfigurationTemplateRequest.applicationName()));
        }
        if (updateConfigurationTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)updateConfigurationTemplateRequest.templateName()));
        }
        if (updateConfigurationTemplateRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)updateConfigurationTemplateRequest.description()));
        }
        if (updateConfigurationTemplateRequest.optionSettings().isEmpty() && !(updateConfigurationTemplateRequest.optionSettings() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionSettings", "");
        } else if (!updateConfigurationTemplateRequest.optionSettings().isEmpty() && !(updateConfigurationTemplateRequest.optionSettings() instanceof SdkAutoConstructList)) {
            List<ConfigurationOptionSetting> optionSettingsList = updateConfigurationTemplateRequest.optionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.resourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringConversion.fromString((String)optionSettingsListValue.resourceName()));
                }
                if (optionSettingsListValue.namespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringConversion.fromString((String)optionSettingsListValue.namespace()));
                }
                if (optionSettingsListValue.optionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringConversion.fromString((String)optionSettingsListValue.optionName()));
                }
                if (optionSettingsListValue.value() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringConversion.fromString((String)optionSettingsListValue.value()));
                }
                ++optionSettingsListIndex;
            }
        }
        if (updateConfigurationTemplateRequest.optionsToRemove().isEmpty() && !(updateConfigurationTemplateRequest.optionsToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionsToRemove", "");
        } else if (!updateConfigurationTemplateRequest.optionsToRemove().isEmpty() && !(updateConfigurationTemplateRequest.optionsToRemove() instanceof SdkAutoConstructList)) {
            List<OptionSpecification> optionsToRemoveList = updateConfigurationTemplateRequest.optionsToRemove();
            int optionsToRemoveListIndex = 1;
            for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue.resourceName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".ResourceName", StringConversion.fromString((String)optionsToRemoveListValue.resourceName()));
                }
                if (optionsToRemoveListValue.namespace() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringConversion.fromString((String)optionsToRemoveListValue.namespace()));
                }
                if (optionsToRemoveListValue.optionName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringConversion.fromString((String)optionsToRemoveListValue.optionName()));
                }
                ++optionsToRemoveListIndex;
            }
        }
        return request;
    }
}

