/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationRequest;

public class UpdateApplicationRequestMarshaller
implements Marshaller<Request<UpdateApplicationRequest>, UpdateApplicationRequest> {
    public Request<UpdateApplicationRequest> marshall(UpdateApplicationRequest updateApplicationRequest) {
        if (updateApplicationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateApplicationRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateApplication");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateApplicationRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)updateApplicationRequest.applicationName()));
        }
        if (updateApplicationRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)updateApplicationRequest.description()));
        }
        return request;
    }
}

