/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest;

public class TerminateEnvironmentRequestMarshaller
implements Marshaller<Request<TerminateEnvironmentRequest>, TerminateEnvironmentRequest> {
    public Request<TerminateEnvironmentRequest> marshall(TerminateEnvironmentRequest terminateEnvironmentRequest) {
        if (terminateEnvironmentRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)terminateEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "TerminateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (terminateEnvironmentRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)terminateEnvironmentRequest.environmentId()));
        }
        if (terminateEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)terminateEnvironmentRequest.environmentName()));
        }
        if (terminateEnvironmentRequest.terminateResources() != null) {
            request.addParameter("TerminateResources", StringConversion.fromBoolean((Boolean)terminateEnvironmentRequest.terminateResources()));
        }
        if (terminateEnvironmentRequest.forceTerminate() != null) {
            request.addParameter("ForceTerminate", StringConversion.fromBoolean((Boolean)terminateEnvironmentRequest.forceTerminate()));
        }
        return request;
    }
}

