/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter;

public class ListPlatformVersionsRequestMarshaller
implements Marshaller<Request<ListPlatformVersionsRequest>, ListPlatformVersionsRequest> {
    public Request<ListPlatformVersionsRequest> marshall(ListPlatformVersionsRequest listPlatformVersionsRequest) {
        if (listPlatformVersionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listPlatformVersionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ListPlatformVersions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPlatformVersionsRequest.filters().isEmpty() && !(listPlatformVersionsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!listPlatformVersionsRequest.filters().isEmpty() && !(listPlatformVersionsRequest.filters() instanceof SdkAutoConstructList)) {
            List<PlatformFilter> filtersList = listPlatformVersionsRequest.filters();
            int filtersListIndex = 1;
            for (PlatformFilter filtersListValue : filtersList) {
                if (filtersListValue.type() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Type", StringConversion.fromString((String)filtersListValue.type()));
                }
                if (filtersListValue.operator() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Operator", StringConversion.fromString((String)filtersListValue.operator()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.member." + filtersListIndex + ".Values.member." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (listPlatformVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)listPlatformVersionsRequest.maxRecords()));
        }
        if (listPlatformVersionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listPlatformVersionsRequest.nextToken()));
        }
        return request;
    }
}

