/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;

public class DescribeEnvironmentsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentsRequest>, DescribeEnvironmentsRequest> {
    public Request<DescribeEnvironmentsRequest> marshall(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        if (describeEnvironmentsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEnvironmentsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEnvironments");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)describeEnvironmentsRequest.applicationName()));
        }
        if (describeEnvironmentsRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringConversion.fromString((String)describeEnvironmentsRequest.versionLabel()));
        }
        if (describeEnvironmentsRequest.environmentIds().isEmpty() && !(describeEnvironmentsRequest.environmentIds() instanceof SdkAutoConstructList)) {
            request.addParameter("EnvironmentIds", "");
        } else if (!describeEnvironmentsRequest.environmentIds().isEmpty() && !(describeEnvironmentsRequest.environmentIds() instanceof SdkAutoConstructList)) {
            List<String> environmentIdsList = describeEnvironmentsRequest.environmentIds();
            int environmentIdsListIndex = 1;
            for (String environmentIdsListValue : environmentIdsList) {
                if (environmentIdsListValue != null) {
                    request.addParameter("EnvironmentIds.member." + environmentIdsListIndex, StringConversion.fromString((String)environmentIdsListValue));
                }
                ++environmentIdsListIndex;
            }
        }
        if (describeEnvironmentsRequest.environmentNames().isEmpty() && !(describeEnvironmentsRequest.environmentNames() instanceof SdkAutoConstructList)) {
            request.addParameter("EnvironmentNames", "");
        } else if (!describeEnvironmentsRequest.environmentNames().isEmpty() && !(describeEnvironmentsRequest.environmentNames() instanceof SdkAutoConstructList)) {
            List<String> environmentNamesList = describeEnvironmentsRequest.environmentNames();
            int environmentNamesListIndex = 1;
            for (String environmentNamesListValue : environmentNamesList) {
                if (environmentNamesListValue != null) {
                    request.addParameter("EnvironmentNames.member." + environmentNamesListIndex, StringConversion.fromString((String)environmentNamesListValue));
                }
                ++environmentNamesListIndex;
            }
        }
        if (describeEnvironmentsRequest.includeDeleted() != null) {
            request.addParameter("IncludeDeleted", StringConversion.fromBoolean((Boolean)describeEnvironmentsRequest.includeDeleted()));
        }
        if (describeEnvironmentsRequest.includedDeletedBackTo() != null) {
            request.addParameter("IncludedDeletedBackTo", StringConversion.fromInstant((Instant)describeEnvironmentsRequest.includedDeletedBackTo()));
        }
        if (describeEnvironmentsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeEnvironmentsRequest.maxRecords()));
        }
        if (describeEnvironmentsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeEnvironmentsRequest.nextToken()));
        }
        return request;
    }
}

