/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest;

public class DescribeEnvironmentManagedActionsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentManagedActionsRequest>, DescribeEnvironmentManagedActionsRequest> {
    public Request<DescribeEnvironmentManagedActionsRequest> marshall(DescribeEnvironmentManagedActionsRequest describeEnvironmentManagedActionsRequest) {
        if (describeEnvironmentManagedActionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEnvironmentManagedActionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEnvironmentManagedActions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentManagedActionsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)describeEnvironmentManagedActionsRequest.environmentName()));
        }
        if (describeEnvironmentManagedActionsRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)describeEnvironmentManagedActionsRequest.environmentId()));
        }
        if (describeEnvironmentManagedActionsRequest.statusAsString() != null) {
            request.addParameter("Status", StringConversion.fromString((String)describeEnvironmentManagedActionsRequest.statusAsString()));
        }
        return request;
    }
}

